/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.variablePanel;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jp.sourceforge.sos.framework.pattern.IObserver;
import jp.sourceforge.sos.lib.variablePanel.IPanelModel;
import jp.sourceforge.sos.lib.variablePanel.IVariableCanvas;
import jp.sourceforge.sos.lib.variablePanel.IVariableModel;

public class JVariablePanel<T extends IVariableModel>
extends JPanel
implements IObserver<T> {
    private ArrayList<IVariableCanvas> listCanvas = new ArrayList();
    private IPanelModel<T> model;
    protected String labelBase;
    private String labelName;
    private Class<IVariableCanvas> canvasClass;
    private IObserver observer;

    public JVariablePanel(Class cls) {
        this.setCanvasClass(cls);
        this.initComponents();
    }

    public JVariablePanel() {
        this.initComponents();
    }

    public void setLabelName(String arg) {
        this.labelName = arg;
    }

    @Override
    public String toString() {
        return this.labelName;
    }

    public IPanelModel<T> getModel() {
        return this.model;
    }

    public void setModel(IPanelModel<T> model) {
        this.model = model;
        this.model.addObserver(this);
        this.synchronizeCanvasToModel();
    }

    private void synchronizeCanvasToModel() {
        int n = this.model.getNumber();
        int oldN = this.listCanvas.size();
        if (oldN == n) {
            return;
        }
        if (oldN < n) {
            this.addCanvases(oldN, n);
        } else {
            this.removeCanvases(oldN - n);
        }
        this.pack();
    }

    private void removeCanvases(int diff) {
        int i = 0;
        while (i < diff) {
            this.removeCanvas(this.listCanvas.size() - 1);
            ++i;
        }
    }

    private void addCanvases(int start, int end) {
        int i = start;
        while (i < end) {
            this.addCanvas((IVariableModel)this.model.get(i));
            ++i;
        }
    }

    public int getColorNumber() {
        return this.listCanvas.size();
    }

    private void addCanvas(T variableModel) {
        IVariableCanvas canvas = this.createCanvas();
        canvas.setModel((IVariableModel)variableModel);
        this.add((Component)((Object)canvas), this.getCanvasConstraints());
        if (this.observer != null) {
            variableModel.addObserver(this.observer);
        }
        JLabel label = new JLabel(String.valueOf(canvas.getLabel()) + ": ");
        label.setForeground(new Color(102, 102, 102));
        this.add((Component)label, this.getLabelConstraints());
    }

    protected IVariableCanvas createCanvas() {
        IVariableCanvas canvas = this.instanceCanvas();
        String label = String.valueOf(this.labelBase) + new Integer(this.listCanvas.size() + 1).toString();
        canvas.setLabel(label);
        this.listCanvas.add(canvas);
        return canvas;
    }

    private IVariableCanvas instanceCanvas() {
        try {
            return this.canvasClass.newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    private GridBagConstraints getCanvasConstraints() {
        GridBagConstraints canvasConst = new GridBagConstraints();
        canvasConst.gridx = 1;
        canvasConst.gridy = -1;
        return canvasConst;
    }

    private GridBagConstraints getLabelConstraints() {
        GridBagConstraints labelConst = new GridBagConstraints();
        labelConst.gridx = 0;
        labelConst.gridy = -1;
        labelConst.anchor = 13;
        labelConst.insets = new Insets(0, 0, 3, 5);
        return labelConst;
    }

    private void removeCanvas(int index) {
        this.remove(index * 2);
        this.remove(index * 2);
        this.listCanvas.remove(index);
    }

    private void pack() {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window != null) {
            window.pack();
        }
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
    }

    public void setObserver(IObserver observer) {
        this.observer = observer;
    }

    @Override
    public void update(T changed) {
        if (changed == null) {
            this.removeCanvas(this.listCanvas.size() - 1);
        } else {
            this.addCanvas(changed);
        }
        this.pack();
    }

    public void setCanvasClass(Class name) {
        this.canvasClass = name;
    }

    public void setLabelBase(String string) {
        this.labelBase = string;
    }

    public void updateCanvases() {
        int i = 0;
        while (i < this.listCanvas.size()) {
            this.listCanvas.get(i).update(null);
            ++i;
        }
    }
}

