/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.variablePanel;

import java.util.ArrayList;
import jp.sourceforge.sos.framework.pattern.IObserver;
import jp.sourceforge.sos.framework.pattern.ObserverSet;
import jp.sourceforge.sos.lib.variablePanel.IPanelModel;

public abstract class AbstractPanelModel<T>
implements IPanelModel<T> {
    private ArrayList<T> listModels = new ArrayList();
    private ObserverSet<T> observers = new ObserverSet();

    @Override
    public int getNumber() {
        return this.listModels.size();
    }

    @Override
    public void setNumber(int n) {
        int oldN = this.listModels.size();
        if (oldN == n) {
            return;
        }
        int diff = n - oldN;
        if (diff > 0) {
            int i = 0;
            while (i < diff) {
                this.add();
                ++i;
            }
        } else {
            int i = diff;
            while (i < 0) {
                this.remove(n);
                ++i;
            }
        }
    }

    private T add() {
        T model = this.createModel();
        this.listModels.add(model);
        this.observers.notify(model);
        return model;
    }

    protected abstract T createModel();

    private void remove(int index) {
        if (index < this.listModels.size()) {
            this.listModels.remove(index);
            this.observers.notify(null);
        }
    }

    @Override
    public void addObserver(IObserver<T> obj) {
        this.observers.addObserver(obj);
    }

    @Override
    public T get(int index) {
        if (index < this.listModels.size()) {
            return this.listModels.get(index);
        }
        return null;
    }
}

