/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.util;

import java.lang.reflect.Array;
import jp.sourceforge.sos.lib.util.FirstInFirstOut;

public abstract class Sort {
    protected int[] ascendingOrder = null;
    protected int minIndex = -1;
    protected int maxIndex = -1;
    protected int inputLength;
    protected int range;
    protected int offset;
    protected int[] heap;

    public final int[] getOrder() {
        return this.ascendingOrder;
    }

    public final void setOrder(int[] order) {
        this.ascendingOrder = order;
    }

    public final int getOrder(int index) {
        return this.ascendingOrder[index];
    }

    public final int[] getRank() {
        int[] ranking = new int[this.ascendingOrder.length];
        int i = 0;
        while (i < this.ascendingOrder.length) {
            ranking[this.ascendingOrder[i]] = i;
            ++i;
        }
        return ranking;
    }

    public int[] getTieRank() {
        int[] tieRank = new int[this.ascendingOrder.length];
        tieRank[0] = 0;
        int i = 1;
        while (i < tieRank.length) {
            int ranking = this.equals(this.ascendingOrder[i], this.ascendingOrder[i - 1]) ? tieRank[this.ascendingOrder[i - 1]] : i;
            tieRank[this.ascendingOrder[i]] = ranking;
            ++i;
        }
        return tieRank;
    }

    protected void swap(int i, int j) {
        int value = this.heap[i];
        this.heap[i] = this.heap[j];
        this.heap[j] = value;
    }

    public int[] getDistributive() {
        FirstInFirstOut fifo = new FirstInFirstOut(this.ascendingOrder.length + 1);
        fifo.add(0);
        int i = 1;
        while (i < this.ascendingOrder.length) {
            if (!this.equals(this.ascendingOrder[i], this.ascendingOrder[i - 1])) {
                fifo.add(i);
            }
            ++i;
        }
        fifo.add(this.ascendingOrder.length);
        return fifo.toArray();
    }

    public abstract void sortAdditional(int var1, int var2);

    protected void sort() {
        int k;
        int j;
        this.heap = new int[this.range];
        int num = 0;
        int i = 0;
        while (i < this.range) {
            this.heap[num++] = i + this.offset;
            j = num;
            k = j / 2;
            while (1 < j && this.compare(this.heap[j - 1], this.heap[k - 1])) {
                this.swap(j - 1, k - 1);
                j = k;
                k = j / 2;
            }
            ++i;
        }
        i = 0;
        while (num > 0) {
            this.ascendingOrder[i + this.offset] = this.heap[0];
            this.heap[0] = this.heap[--num];
            j = 1;
            k = j * 2;
            while (k <= num) {
                if (k + 1 <= num && this.compare(this.heap[k], this.heap[k - 1])) {
                    ++k;
                }
                if (this.compare(this.heap[k - 1], this.heap[j - 1])) {
                    this.swap(j - 1, k - 1);
                }
                j = k;
                k = j * 2;
            }
            ++i;
        }
        this.heap = null;
    }

    protected abstract boolean compare(int var1, int var2);

    protected abstract boolean equals(int var1, int var2);

    public final <T> T[] sort(T[] data) {
        Object[] result = (Object[])Array.newInstance(data.getClass().getComponentType(), data.length);
        int i = 0;
        while (i < data.length) {
            result[i] = data[this.ascendingOrder[i]];
            ++i;
        }
        return result;
    }

    public final double[] sort(double[] data) {
        double[] result = new double[data.length];
        int i = 0;
        while (i < data.length) {
            result[i] = data[this.ascendingOrder[i]];
            ++i;
        }
        return result;
    }

    public final int[] sort(int[] data) {
        int[] result = new int[data.length];
        int i = 0;
        while (i < data.length) {
            result[i] = data[this.ascendingOrder[i]];
            ++i;
        }
        return result;
    }

    protected void setRange(int start, int end) {
        this.offset = start;
        this.range = end - start;
    }

    protected void initAscendingOrder(int l) {
        this.ascendingOrder = new int[l];
        int i = 0;
        while (i < l) {
            this.ascendingOrder[i] = i;
            ++i;
        }
    }
}

