/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.threedim;

import jp.sourceforge.sos.lib.threedim.Object3D;
import jp.sourceforge.sos.lib.threedim.Vertex;

public class Line3D
extends Object3D {
    public Line3D() {
        this.vertices.add(new Vertex());
        this.vertices.add(new Vertex());
    }

    public Line3D(Vertex v1, Vertex v2) {
        this();
        this.setLine(v1, v2);
    }

    public void setLine(Vertex v1, Vertex v2) {
        this.setLine(v1.getLocation(), v2.getLocation());
    }

    public void setLine(double[] c1, double[] c2) {
        ((Vertex)this.vertices.get(0)).setLocation(c1);
        ((Vertex)this.vertices.get(1)).setLocation(c2);
        this.update();
    }

    public double ptSegDistSq(Vertex v) {
        return this.ptSegDistSq(v.getLocation());
    }

    public double ptSegDistSq(double[] coordinates) {
        double ZPt;
        double YPt;
        double XPt;
        double XLine = ((Vertex)this.vertices.get(1)).getX() - ((Vertex)this.vertices.get(0)).getX();
        double YLine = ((Vertex)this.vertices.get(1)).getY() - ((Vertex)this.vertices.get(0)).getY();
        double ZLine = ((Vertex)this.vertices.get(1)).getZ() - ((Vertex)this.vertices.get(0)).getZ();
        double dotprod = XLine * (XPt = coordinates[0] - ((Vertex)this.vertices.get(0)).getX()) + YLine * (YPt = coordinates[1] - ((Vertex)this.vertices.get(0)).getY()) + ZLine * (ZPt = coordinates[2] - ((Vertex)this.vertices.get(0)).getZ());
        double projlenSq = dotprod <= 0.0 ? 0.0 : ((dotprod = XLine * (XPt = XLine - XPt) + YLine * (YPt = YLine - YPt) + ZLine * (ZPt = ZLine - ZPt)) <= 0.0 ? 0.0 : dotprod * dotprod / (XLine * XLine + YLine * YLine + ZLine * ZLine));
        double lenSq = XPt * XPt + YPt * YPt + ZPt * ZPt - projlenSq;
        if (lenSq < 0.0) {
            lenSq = 0.0;
        }
        return lenSq;
    }

    public double[] toVector() {
        double[] result = new double[]{((Vertex)this.vertices.get(1)).getX() - ((Vertex)this.vertices.get(0)).getX(), ((Vertex)this.vertices.get(1)).getY() - ((Vertex)this.vertices.get(0)).getY(), ((Vertex)this.vertices.get(1)).getZ() - ((Vertex)this.vertices.get(0)).getZ()};
        return result;
    }
}

