/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.panel;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class JIndexPanel
extends JPanel {
    private static final long serialVersionUID = 2064202760075375586L;
    private int index;
    private int offset;
    private int minSentinel;
    private int maxSentinel;
    public static final String PROP_INDEX = "index";
    private PropertyChangeSupport propertySupport;
    private JButton jButtonFirst;
    private JButton jButtonLast;
    private JButton jButtonNext;
    private JButton jButtonPrev;
    private JLabel jLabelIndex;

    public JIndexPanel() {
        this.initComponents();
        this.propertySupport = new PropertyChangeSupport(this);
        this.setValues(0, -1, 2);
    }

    public void setValues(int offset, int min, int max) {
        this.offset = offset;
        this.minSentinel = min;
        this.maxSentinel = max;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int i) {
        if (this.minSentinel < i && i < this.maxSentinel) {
            int oldValue = this.index;
            this.index = i;
            this.propertySupport.firePropertyChange(PROP_INDEX, oldValue, this.index);
            this.jLabelIndex.setText(Integer.toString(this.index + this.offset));
        }
    }

    public void addMaxSentinel() {
        ++this.maxSentinel;
    }

    public void subtractMaxSentinel() {
        --this.maxSentinel;
        if (this.maxSentinel <= this.index) {
            this.setIndex(this.maxSentinel - 1);
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    private void initComponents() {
        this.jButtonFirst = new JButton();
        this.jButtonPrev = new JButton();
        this.jLabelIndex = new JLabel();
        this.jButtonNext = new JButton();
        this.jButtonLast = new JButton();
        this.jButtonFirst.setFont(new Font("MS UI Gothic", 1, 10));
        this.jButtonFirst.setForeground(new Color(0, 0, 255));
        this.jButtonFirst.setText("|<");
        this.jButtonFirst.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JIndexPanel.this.jButtonFirstActionPerformed(evt);
            }
        });
        this.add(this.jButtonFirst);
        this.jButtonPrev.setFont(new Font("MS UI Gothic", 1, 10));
        this.jButtonPrev.setForeground(new Color(0, 0, 255));
        this.jButtonPrev.setText("<<");
        this.jButtonPrev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JIndexPanel.this.jButtonPrevActionPerformed(evt);
            }
        });
        this.add(this.jButtonPrev);
        this.jLabelIndex.setHorizontalAlignment(0);
        this.jLabelIndex.setText("0");
        this.jLabelIndex.setMinimumSize(new Dimension(30, 20));
        this.jLabelIndex.setPreferredSize(new Dimension(30, 20));
        this.add(this.jLabelIndex);
        this.jButtonNext.setFont(new Font("MS UI Gothic", 1, 10));
        this.jButtonNext.setForeground(new Color(0, 0, 255));
        this.jButtonNext.setText(">>");
        this.jButtonNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JIndexPanel.this.jButtonNextActionPerformed(evt);
            }
        });
        this.add(this.jButtonNext);
        this.jButtonLast.setFont(new Font("MS UI Gothic", 1, 10));
        this.jButtonLast.setForeground(new Color(0, 0, 255));
        this.jButtonLast.setText(">|");
        this.jButtonLast.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JIndexPanel.this.jButtonLastActionPerformed(evt);
            }
        });
        this.add(this.jButtonLast);
    }

    private void jButtonLastActionPerformed(ActionEvent evt) {
        this.setIndex(this.maxSentinel - 1);
    }

    private void jButtonFirstActionPerformed(ActionEvent evt) {
        this.setIndex(this.minSentinel + 1);
    }

    private void jButtonPrevActionPerformed(ActionEvent evt) {
        this.setIndex(this.index - 1);
    }

    private void jButtonNextActionPerformed(ActionEvent evt) {
        this.setIndex(this.index + 1);
    }
}

