/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.panel;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class JGenericPanel
extends JPanel {
    private static final long serialVersionUID = 7978143378983490333L;
    private int nItem = 0;
    private ArrayList<JSpinner> listNumberSpinner;
    private ArrayList<JFormattedTextField> listNumberField;
    private ArrayList<JComboBox> listChoiceField;

    public JGenericPanel() {
        this.setLayout(new GridBagLayout());
        this.listNumberSpinner = new ArrayList();
        this.listNumberField = new ArrayList();
        this.listChoiceField = new ArrayList();
    }

    private void addComponent(String label, JComponent component) {
        JLabel jLabel = new JLabel(label);
        this.add((Component)jLabel, this.getGridBagConstraints(0, this.nItem, true));
        this.add((Component)component, this.getGridBagConstraints(1, this.nItem, false));
        ++this.nItem;
    }

    private GridBagConstraints getGridBagConstraints(int x, int y, boolean isLabel) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = x;
        constraints.gridy = y;
        constraints.gridwidth = 1;
        if (isLabel) {
            constraints.anchor = 13;
            constraints.insets = new Insets(0, 10, 0, 1);
        } else {
            constraints.fill = 2;
            constraints.insets = new Insets(0, 1, 0, 10);
        }
        return constraints;
    }

    public void addChoice(String label, String[] items, int defaultItemIndex) {
        JComboBox<String> comboBox = new JComboBox<String>();
        int i = 0;
        while (i < items.length) {
            comboBox.addItem(items[i]);
            ++i;
        }
        comboBox.setSelectedIndex(defaultItemIndex);
        this.addComponent(label, comboBox);
        this.listChoiceField.add(comboBox);
    }

    public void addNumericField(String label, double defaultValue, int digits) {
        DecimalFormat nf = new DecimalFormat();
        nf.setMinimumFractionDigits(digits);
        nf.setMaximumFractionDigits(digits);
        JFormattedTextField formattedField = new JFormattedTextField(nf);
        formattedField.setValue(defaultValue);
        formattedField.setPreferredSize(new Dimension(80, 18));
        formattedField.setHorizontalAlignment(4);
        this.addComponent(label, formattedField);
        this.listNumberField.add(formattedField);
    }

    public void addNumericSpinner(String label, SpinnerNumberModel model) {
        JSpinner spinner = new JSpinner(model);
        spinner.setPreferredSize(new Dimension(80, 18));
        this.addComponent(label, spinner);
        this.listNumberSpinner.add(spinner);
    }

    public Object getSpinnerNumber(int componentIndex) {
        JSpinner spinner = this.listNumberSpinner.get(componentIndex);
        return spinner.getValue();
    }

    public double getFieldNumber(int componentIndex) {
        JFormattedTextField formattedField = this.listNumberField.get(componentIndex);
        try {
            formattedField.commitEdit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ((Number)formattedField.getValue()).doubleValue();
    }

    public int getChoiceIndex(int componentIndex) {
        JComboBox comboBox = this.listChoiceField.get(componentIndex);
        return comboBox.getSelectedIndex();
    }

    public void addComponent(JComponent component) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = this.nItem++;
        constraints.gridwidth = 2;
        this.add((Component)component, constraints);
    }
}

