/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.morphology.extra;

import jp.sourceforge.sos.lib.image.LabeledImage;
import jp.sourceforge.sos.lib.math.MathVector;
import jp.sourceforge.sos.lib.morphology.connection.AbstractNeighbor;
import jp.sourceforge.sos.lib.util.FirstInFirstOut;
import jp.sourceforge.sos.lib.util.Sort;
import jp.sourceforge.sos.lib.util.SortDouble;
import jp.sourceforge.sos.lib.util.SortInteger;

public class Watershed {
    private int INITIAL;
    private int UNDETERMINED;
    private int WATERSHED;
    private static FirstInFirstOut fifoMain = new FirstInFirstOut(1);
    private static FirstInFirstOut fifoWshed = new FirstInFirstOut(1);
    private AbstractNeighbor neighborF = null;
    private LabeledImage imi = null;
    private int[] order = null;
    private int[] denomination = null;
    private int waterLevel;

    public Watershed(LabeledImage imi, int firstLabel) {
        this.imi = imi;
        if (fifoMain.getCapacity() < imi.getImageSize()) {
            fifoMain = new FirstInFirstOut(imi.getImageSize());
            fifoWshed = new FirstInFirstOut(imi.getImageSize());
        }
        this.INITIAL = firstLabel - 4;
        this.WATERSHED = firstLabel - 2;
        this.UNDETERMINED = firstLabel - 1;
        this.waterLevel = 2;
        this.neighborF = imi.getNeighbor();
    }

    public final void setOrder(double[] gradient) {
        double[] result = new double[gradient.length];
        int[] labels = this.imi.getLabels();
        int pn = 0;
        while (pn < this.imi.getImageSize()) {
            result[pn] = labels[pn] > this.UNDETERMINED ? 0.0 : gradient[pn] + 1.0;
            ++pn;
        }
        SortDouble sd = new SortDouble(result);
        this.setOrderAndDenomination(sd);
    }

    public final void setOrder(int[] gradient) {
        int[] result = new int[gradient.length];
        int[] labels = this.imi.getLabels();
        int pn = 0;
        while (pn < this.imi.getImageSize()) {
            result[pn] = labels[pn] > this.UNDETERMINED ? 0 : gradient[pn] + 1;
            ++pn;
        }
        SortInteger si = new SortInteger(gradient);
        this.setOrderAndDenomination(si);
    }

    private final void setOrderAndDenomination(Sort so) {
        this.order = so.getOrder();
        this.denomination = so.getDistributive();
    }

    public final boolean isConvergence() {
        if (this.waterLevel + 1 < this.denomination.length) {
            ++this.waterLevel;
            return false;
        }
        return true;
    }

    public final int flood4() {
        this.neighborF.set4();
        return this.flood();
    }

    public final int flood8() {
        this.neighborF.set8();
        return this.flood();
    }

    private final int flood() {
        int n;
        int[] neighbor;
        int count = 0;
        int[] labels = this.imi.getLabels();
        int i = this.denomination[this.waterLevel - 1];
        while (i < this.denomination[this.waterLevel]) {
            this.imi.setPixelsLabel(this.order[i], this.UNDETERMINED);
            neighbor = this.neighborF.getExist(this.order[i]);
            n = 0;
            while (n < neighbor.length) {
                if (labels[this.order[i] + neighbor[n]] > this.UNDETERMINED) {
                    fifoMain.add(this.order[i]);
                    break;
                }
                ++n;
            }
            ++i;
        }
        while (!fifoMain.isEmpty()) {
            int cn;
            int cp = fifoMain.get();
            ++count;
            int[] pixelsLabel = this.imi.getLabels();
            if (labels[cp] != this.UNDETERMINED) continue;
            neighbor = this.neighborF.getExist(cp);
            n = 0;
            while (n < neighbor.length) {
                cn = cp + neighbor[n];
                if (labels[cn] > this.UNDETERMINED) {
                    if (labels[cp] == this.UNDETERMINED) {
                        this.imi.setPixelsLabel(cp, labels[cn]);
                    } else if (labels[cp] != pixelsLabel[cn]) {
                        this.imi.setPixelsLabel(cp, this.WATERSHED);
                        fifoWshed.add(cp);
                        break;
                    }
                }
                ++n;
            }
            if (labels[cp] <= this.UNDETERMINED) continue;
            n = 0;
            while (n < neighbor.length) {
                cn = cp + neighbor[n];
                if (labels[cn] == this.UNDETERMINED) {
                    fifoMain.add(cn);
                }
                ++n;
            }
        }
        return count;
    }

    public final void undeterminedToWatershed() {
        int[] pixelsLabel = this.imi.getLabels();
        int pn = 0;
        while (pn < this.neighborF.getSize()) {
            if (pixelsLabel[pn] == this.UNDETERMINED) {
                this.imi.setPixelsLabel(pn, this.WATERSHED);
                fifoWshed.add(pn);
            }
            ++pn;
        }
    }

    public final void assignLabelOfClosest(int[][] input) {
        this.undeterminedToWatershed();
        do {
            int pn = fifoWshed.get();
            int[] neighbor = this.neighborF.getExist(pn);
            int[] norm = new int[neighbor.length];
            int n = 0;
            while (n < neighbor.length) {
                norm[n] = MathVector.norm(input[pn], input[pn + neighbor[n]]);
                ++n;
            }
            this.setClosestLabel(pn, neighbor, new SortInteger(norm));
        } while (!fifoWshed.isEmpty());
    }

    public final void assignLabelOfClosest(int[][] input, int[] pns) {
        int i = 0;
        while (i < pns.length) {
            int pn = pns[i];
            int[] neighbor = this.neighborF.getExist(pn);
            int[] norm = new int[neighbor.length];
            int n = 0;
            while (n < neighbor.length) {
                norm[n] = MathVector.norm(input[pn], input[pn + neighbor[n]]);
                ++n;
            }
            this.setClosestLabel(pn, neighbor, new SortInteger(norm));
            ++i;
        }
    }

    public final void assignLabelOfClosest(double[][] input) {
        this.undeterminedToWatershed();
        do {
            int pn = fifoWshed.get();
            int[] neighbor = this.neighborF.getExist(pn);
            double[] norm = new double[neighbor.length];
            int n = 0;
            while (n < neighbor.length) {
                norm[n] = MathVector.norm(input[pn], input[pn + neighbor[n]]);
                ++n;
            }
            this.setClosestLabel(pn, neighbor, new SortDouble(norm));
        } while (!fifoWshed.isEmpty());
    }

    private final void setClosestLabel(int pn, int[] neighbor, Sort so) {
        int[] order = so.getOrder();
        int[] pixelsLabel = this.imi.getLabels();
        int n = 0;
        while (n < neighbor.length) {
            int cn = pn + neighbor[order[n]];
            if (pixelsLabel[cn] > this.UNDETERMINED) {
                this.imi.setPixelsLabel(pn, pixelsLabel[cn]);
                return;
            }
            ++n;
        }
    }

    public final int[] getWatershed() {
        return fifoWshed.toArray();
    }

    public final FirstInFirstOut getFIFO() {
        return fifoMain;
    }

    public final void setFIFOMarker() {
        fifoMain.setMarker();
    }

    public int getWATERSHED() {
        return this.WATERSHED;
    }

    public int getINITIAL() {
        return this.INITIAL;
    }
}

