/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.morphology.extra;

import jp.sourceforge.sos.lib.morphology.data.Elements;
import jp.sourceforge.sos.lib.morphology.extra.AbstractOperation;

public class GeodesicDistance
extends AbstractOperation {
    @Override
    public void operate(Elements elements) {
        this.init(elements);
        int[] resultMap = (int[])elements.getResultData();
        boolean[] binaryMap = (boolean[])elements.getInputData();
        this.calcDistance(binaryMap, resultMap);
    }

    private void calcDistance(boolean[] binaryMap, int[] resultMap) {
        int pn = 0;
        while (pn < binaryMap.length) {
            if (binaryMap[pn]) {
                int[] se = this.neighbor.getExist(pn);
                int n = 0;
                while (n < se.length) {
                    if (!binaryMap[pn + se[n]]) {
                        resultMap[pn] = 1;
                        this.fifo.add(pn);
                        break;
                    }
                    ++n;
                }
            }
            ++pn;
        }
        while (!this.fifo.isEmpty()) {
            int cp = this.fifo.get();
            int[] se = this.neighbor.getExist(cp);
            int n = 0;
            while (n < se.length) {
                int cn = cp + se[n];
                if (resultMap[cn] == 0 && binaryMap[cn]) {
                    resultMap[cn] = resultMap[cp] + 1;
                    this.fifo.add(cn);
                }
                ++n;
            }
        }
    }
}

