/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.morphology.extra;

import java.util.Arrays;
import jp.sourceforge.sos.lib.morphology.data.DataInt;
import jp.sourceforge.sos.lib.morphology.data.Elements;
import jp.sourceforge.sos.lib.morphology.extra.AbstractOperation;

public class ExtractRegion
extends AbstractOperation {
    private int regionNumber;

    @Override
    public void operate(Elements elements) {
        this.init(elements);
        elements.setResult(new DataInt(elements.size()));
        int[] resultMap = (int[])elements.getResultData();
        int background = -1;
        Arrays.fill(resultMap, background);
        boolean[] binaryMap = (boolean[])elements.getInputData();
        this.regionNumber = 0;
        int pn = 0;
        while (pn < elements.size()) {
            if (binaryMap[pn] && resultMap[pn] == background) {
                resultMap[pn] = this.regionNumber++;
                this.fifo.add(pn);
                this.loop(resultMap, background, binaryMap);
            }
            ++pn;
        }
    }

    private void loop(int[] resultMap, int background, boolean[] binaryMap) {
        do {
            int cp = this.fifo.get();
            int[] se = this.neighbor.getExist(cp);
            int i = 0;
            while (i < se.length) {
                int cn = cp + se[i];
                if (binaryMap[cn] && resultMap[cn] == background) {
                    resultMap[cn] = this.regionNumber;
                    this.fifo.add(cn);
                }
                ++i;
            }
        } while (this.fifo.getSize() > 0);
    }

    public int getRegionNumber() {
        return this.regionNumber;
    }
}

