/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.morphology.connection;

import java.util.Arrays;
import jp.sourceforge.sos.lib.morphology.connection.AbstractNeighbor;

public class NeighborMasked
extends AbstractNeighbor {
    private static final int[] zeroSizeArray = new int[0];
    private boolean[] mask;
    private int[] tempDir;
    private boolean[] maskedNeighbor;

    public NeighborMasked(int w, int h) {
        super(w, h);
    }

    @Override
    public void setMask(boolean[] mask) {
        if (mask.length != this.getSize()) {
            return;
        }
        this.mask = mask;
    }

    @Override
    public boolean[] getMask() {
        return this.mask;
    }

    @Override
    public int[] getDir(int pn) {
        int[] n = super.getDir(pn);
        boolean changed = false;
        int i = 0;
        while (i < n.length) {
            if (this.mask[pn + n[i]]) {
                if (!changed) {
                    System.arraycopy(n, 0, this.tempDir, 0, n.length);
                    changed = true;
                }
                this.tempDir[i] = 0;
            }
            ++i;
        }
        int[] result = changed ? this.tempDir : n;
        return result;
    }

    @Override
    public int[] getExist(int pn) {
        if (this.mask[pn]) {
            return zeroSizeArray;
        }
        int[] neighbor = super.getExist(pn);
        boolean changed = false;
        int maskedNumber = 0;
        int i = 0;
        while (i < neighbor.length) {
            if (this.mask[pn + neighbor[i]]) {
                if (!changed) {
                    Arrays.fill(this.maskedNeighbor, false);
                    changed = true;
                }
                this.maskedNeighbor[i] = true;
                ++maskedNumber;
            }
            ++i;
        }
        int[] result = neighbor;
        if (changed) {
            result = new int[neighbor.length - maskedNumber];
            int index = 0;
            int i2 = 0;
            while (i2 < neighbor.length) {
                if (!this.maskedNeighbor[i2]) {
                    result[index] = neighbor[i2];
                    ++index;
                }
                ++i2;
            }
        }
        return result;
    }

    @Override
    public void set8() {
        super.set8();
        this.setTemp();
    }

    @Override
    public void set4() {
        super.set4();
        this.setTemp();
    }

    private void setTemp() {
        int n = this.current.number;
        this.tempDir = new int[n];
        this.maskedNeighbor = new boolean[n];
    }
}

