/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.morphology.connection;

public abstract class AbstractConnection {
    private static final int[] ANTI_CLOCKWISE_X;
    private static final int[] ANTI_CLOCKWISE_Y;
    private static final int[] ANTI_CLOCKWISE;
    private static int[] temp;
    int width;
    int number;
    int[][] direction = new int[9][];
    int[][] exist = new int[9][];

    static {
        temp = new int[9];
        int[] nArray = new int[8];
        nArray[0] = -1;
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[6] = -1;
        nArray[7] = -1;
        ANTI_CLOCKWISE_X = nArray;
        int[] nArray2 = new int[8];
        nArray2[0] = 1;
        nArray2[1] = 1;
        nArray2[2] = 1;
        nArray2[4] = -1;
        nArray2[5] = -1;
        nArray2[6] = -1;
        ANTI_CLOCKWISE_Y = nArray2;
        ANTI_CLOCKWISE = new int[ANTI_CLOCKWISE_X.length];
        int i = 0;
        while (i < ANTI_CLOCKWISE.length) {
            AbstractConnection.ANTI_CLOCKWISE[i] = ANTI_CLOCKWISE_X[i] + 1 + (ANTI_CLOCKWISE_Y[i] + 1) * 3;
            ++i;
        }
    }

    public AbstractConnection() {
        this.init();
    }

    abstract void init();

    public void setWidth(int width) {
        this.width = width;
        this.setDirection();
        this.setExist(this.direction);
    }

    private void setDirection() {
        int index = 0;
        int y = 0;
        while (y < 3) {
            int x = 0;
            while (x < 3) {
                this.direction[index] = this.calc(y, x);
                ++index;
                ++x;
            }
            ++y;
        }
    }

    private int[] calc(int y, int x) {
        int[] result = new int[8];
        int i = 0;
        while (i < ANTI_CLOCKWISE.length) {
            if (this.isInStructure(ANTI_CLOCKWISE[i])) {
                int tempX = ANTI_CLOCKWISE_X[i] + x;
                int tempY = ANTI_CLOCKWISE_Y[i] + y;
                if (tempX >= 0 && tempX < 3 && tempY >= 0 && tempY < 3) {
                    result[i] = ANTI_CLOCKWISE_X[i] + ANTI_CLOCKWISE_Y[i] * this.width;
                }
            }
            ++i;
        }
        return result;
    }

    abstract boolean isInStructure(int var1);

    public int getNumber() {
        return this.number;
    }

    public int[] getDirect(int i) {
        return this.direction[i];
    }

    public int[] getExist(int i) {
        return this.exist[i];
    }

    private void setExist(int[][] direction) {
        int i = 0;
        while (i < direction.length) {
            this.exist[i] = this.toExist(direction[i]);
            ++i;
        }
    }

    private int[] toExist(int[] direction) {
        int n = 0;
        int i = 0;
        while (i < direction.length) {
            if (direction[i] != 0) {
                AbstractConnection.temp[n] = direction[i];
                ++n;
            }
            ++i;
        }
        int[] result = new int[n];
        System.arraycopy(temp, 0, result, 0, n);
        return result;
    }
}

