/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.morphology;

import jp.sourceforge.sos.lib.morphology.Dilation;
import jp.sourceforge.sos.lib.morphology.Erosion;
import jp.sourceforge.sos.lib.morphology.IOperation;
import jp.sourceforge.sos.lib.morphology.data.Elements;
import jp.sourceforge.sos.lib.morphology.data.IData;
import jp.sourceforge.sos.lib.morphology.data.IDataBase;

abstract class OpenClose
implements IOperation {
    private Dilation dilation = new Dilation();
    private Erosion erosion = new Erosion();
    private int iteration = 1;

    public void setIteration(int n) {
        this.iteration = n;
    }

    void erode(Elements elements) {
        this.setElements(elements);
        int i = 0;
        while (i < this.iteration) {
            this.erosion.operate(elements);
            elements.resultToInput();
            ++i;
        }
    }

    void dilate(Elements elements) {
        this.setElements(elements);
        int i = 0;
        while (i < this.iteration) {
            this.dilation.operate(elements);
            elements.resultToInput();
            ++i;
        }
    }

    private void setElements(Elements elements) {
        IDataBase input = elements.getInput();
        IData copy = input.getInstance(elements.size());
        System.arraycopy(input.get(), 0, copy.get(), 0, elements.size());
        elements.setInput(copy);
        elements.createResult();
    }
}

