/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.math.equation;

import java.util.LinkedList;
import jp.sourceforge.sos.framework.util.Factory;
import jp.sourceforge.sos.lib.math.equation.IOperator;

public class CalculationEquation {
    private char character;
    private String strIn;
    private int nextStrIn;
    private StringBuffer strOut;
    private IOperator[] operators = (IOperator[])Factory.getInstances(IOperator.class);

    private void setCharacter() throws RuntimeException {
        if (this.nextStrIn == this.strIn.length()) {
            throw new RuntimeException("'" + this.character + "' \u4ee5\u964d\u7d9a\u304d\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
        }
        do {
            this.character = this.strIn.charAt(this.nextStrIn++);
        } while (this.character == ' ' || this.character == '\t');
        if (Character.isLowerCase(this.character)) {
            this.character = Character.toUpperCase(this.character);
        }
    }

    private boolean isEqual(String func) {
        int len = func.length();
        if (this.nextStrIn + len - 1 > this.strIn.length()) {
            return false;
        }
        String subs = this.strIn.substring(this.nextStrIn - 1, this.nextStrIn + len - 1);
        if (func.equalsIgnoreCase(subs)) {
            this.nextStrIn += len - 1;
            this.setCharacter();
            return true;
        }
        return false;
    }

    private void expression() throws RuntimeException {
        this.term();
        while (this.character == '+' || this.character == '-') {
            char old_ch = this.character;
            this.setCharacter();
            this.term();
            this.strOut.append(String.valueOf(old_ch) + ",");
        }
    }

    private void term() throws RuntimeException {
        this.sign();
        while (this.character == '*' || this.character == '/') {
            char old_ch = this.character;
            this.setCharacter();
            this.sign();
            this.strOut.append(String.valueOf(old_ch) + ",");
        }
    }

    private void sign() throws RuntimeException {
        if (this.character == '-') {
            this.setCharacter();
            this.sign();
            this.strOut.append("-1,*,");
        } else if (this.character == '+') {
            this.setCharacter();
            this.sign();
        } else {
            this.pow();
        }
    }

    private void pow() throws RuntimeException {
        this.function();
        while (this.character == '^') {
            char old_ch = this.character;
            this.setCharacter();
            this.sign();
            this.strOut.append(String.valueOf(old_ch) + ",");
        }
    }

    private void signPreFunction() throws RuntimeException {
        if (this.character == '-') {
            this.setCharacter();
            this.signPreFunction();
            this.strOut.append("-1,*,");
        } else if (this.character == '+') {
            this.setCharacter();
            this.signPreFunction();
        } else {
            this.function();
        }
    }

    private void function() throws RuntimeException {
        int i = 0;
        while (i < this.operators.length) {
            String sign;
            IOperator operator = this.operators[i];
            if (operator.isType(IOperator.Type.FUNCTION) && this.isEqual(sign = operator.getSign())) {
                this.signPreFunction();
                this.strOut.append(String.valueOf(sign) + ",");
                return;
            }
            ++i;
        }
        this.factor();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void factor() throws RuntimeException {
        if (this.character == '(') {
            this.setCharacter();
            this.expression();
            if (this.character != ')') throw new RuntimeException("\u5bfe\u5fdc\u3059\u308b')'\u304c\u3042\u308a\u307e\u305b\u3093\u3002");
            this.setCharacter();
            return;
        } else if (Character.isDigit(this.character) || this.character == '.') {
            this.number();
            this.strOut.append(',');
            return;
        } else if (Character.isUpperCase(this.character)) {
            this.variable();
            this.strOut.append(',');
            return;
        } else {
            if (this.character != '\n') throw new RuntimeException("'" + this.character + "' \u4e0d\u660e\u306a\u6587\u5b57\u3067\u3059\u3002");
            throw new RuntimeException("\u5f0f\u304c\u9014\u4e2d\u3067\u7d42\u308f\u3063\u3066\u3044\u307e\u3059\u3002");
        }
    }

    private void variable() {
        while (Character.isUpperCase(this.character) || Character.isDigit(this.character) || this.character == '_') {
            this.strOut.append(this.character);
            this.setCharacter();
        }
    }

    private void number() throws RuntimeException {
        while (Character.isDigit(this.character)) {
            this.strOut.append(this.character);
            this.setCharacter();
        }
        if (this.character == '.') {
            this.strOut.append(this.character);
            this.setCharacter();
            this.number_();
        }
        if (this.character == 'E') {
            this.strOut.append(this.character);
            this.setCharacter();
            if (this.character == '-' || this.character == '+') {
                this.strOut.append(this.character);
                this.setCharacter();
                this.number_();
            } else {
                this.number_();
            }
        }
    }

    private void number_() throws RuntimeException {
        if (Character.isDigit(this.character)) {
            do {
                this.strOut.append(this.character);
                this.setCharacter();
            } while (Character.isDigit(this.character));
        } else {
            throw new RuntimeException("\u5c0f\u6570\u70b9\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u30a8\u30e9\u30fc\u3002");
        }
    }

    private String convert(String equation) throws RuntimeException {
        this.strIn = String.valueOf(equation) + '\n';
        this.strOut = new StringBuffer();
        this.nextStrIn = 0;
        this.setCharacter();
        this.expression();
        if (this.character != '\n') {
            throw new RuntimeException("'" + this.character + "' \u4f59\u5206\u306a\u6587\u5b57\u3067\u3059\u3002");
        }
        String postfix = new String(this.strOut);
        this.strIn = null;
        this.strOut = null;
        return postfix;
    }

    public double calc(String arg) {
        String expression = this.convert(arg);
        String[] elements = expression.split(",");
        return this.calc(elements);
    }

    public double calc(String[] elements) {
        LinkedList<Double> stack = new LinkedList<Double>();
        int i = 0;
        while (i < elements.length) {
            try {
                stack.add(new Double(elements[i]));
            }
            catch (NumberFormatException e) {
                this.operation(stack, elements[i]);
            }
            ++i;
        }
        return (Double)stack.removeLast();
    }

    private void operation(LinkedList<Double> stack, String operator) throws RuntimeException {
        int i = 0;
        while (i < this.operators.length) {
            if (this.operators[i].means(operator)) {
                this.operators[i].operate(stack);
                return;
            }
            ++i;
        }
        if (operator.length() == 1) {
            throw new RuntimeException("'" + operator + "' undefined.");
        }
        throw new RuntimeException("\"" + operator + "\" undefined.");
    }
}

