/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.math;

import java.util.Arrays;
import jp.sourceforge.sos.lib.math.MathVector;

public class Unit {
    public double[] cumInput;
    public double[] mean;
    public double[] preMean;
    public double alpha;
    public double nBelong;
    public int index;

    public Unit(int dim) {
        this.mean = new double[dim];
        this.preMean = new double[dim];
        this.cumInput = new double[dim];
    }

    public void backupMean() {
        System.arraycopy(this.mean, 0, this.preMean, 0, this.mean.length);
    }

    public double calcMeanDifference() {
        return MathVector.norm(this.mean, this.preMean);
    }

    public void calcMean() {
        if (this.nBelong != 0.0) {
            int i = 0;
            while (i < this.mean.length) {
                this.mean[i] = this.cumInput[i] / this.nBelong;
                ++i;
            }
        }
    }

    public void initCalculation() {
        this.nBelong = 0.0;
        Arrays.fill(this.cumInput, 0.0);
    }
}

