/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JFileChooser;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import jp.sourceforge.sos.lib.io.Extension;
import jp.sourceforge.sos.lib.io.ExtensionFilter;

public class SOSFileIO {
    public static final ExtensionFilter txtFilter = new ExtensionFilter(new String[]{"txt"}, "Text File");
    protected JFileChooser chooser = new JFileChooser();

    public void resetChoosableFileFilters() {
        this.chooser.resetChoosableFileFilters();
    }

    public void setFileFilter(FileFilter filter) {
        this.chooser.setFileFilter(filter);
    }

    public void addChoosableFileFilter(FileFilter filter) {
        this.chooser.addChoosableFileFilter(filter);
    }

    public File getOpenFile() {
        return this.getOpenFile("Open file...");
    }

    public File getSaveFile() {
        return this.getSaveFile("Save file...");
    }

    public File getOpenFile(String title) {
        this.chooser.setFileSelectionMode(0);
        return this.getFile(title, true);
    }

    public File getSaveFile(String title) {
        this.chooser.setFileSelectionMode(0);
        return this.appendSuffix(this.getFile(title, false));
    }

    public File getOpenDirectory() {
        this.chooser.setFileSelectionMode(1);
        return this.getFile("Select folder to open...", true);
    }

    public File getSaveDirectory() {
        this.chooser.setFileSelectionMode(1);
        return this.getFile("Select folder to save...", false);
    }

    private File getFile(String title, boolean isOpen) {
        FileFilter filter = this.chooser.getFileFilter();
        int result = 0;
        try {
            LookAndFeel previousLookAndFeel = UIManager.getLookAndFeel();
            String systemLF = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(systemLF);
            this.chooser.setDialogTitle(title);
            this.chooser.updateUI();
            this.chooser.setFileFilter(filter);
            result = isOpen ? this.chooser.showOpenDialog(null) : this.chooser.showSaveDialog(null);
            UIManager.setLookAndFeel(previousLookAndFeel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        File file = null;
        if (result == 0) {
            file = this.chooser.getSelectedFile();
        }
        return file;
    }

    public void setCurrentDirectory(File dir) {
        this.chooser.setCurrentDirectory(dir);
    }

    public void setCurrentDirectory(String path) {
        this.chooser.setCurrentDirectory(new File(path));
    }

    private File appendSuffix(File file) {
        if (file == null) {
            return null;
        }
        FileFilter current = this.chooser.getFileFilter();
        File result = null;
        if (current instanceof ExtensionFilter) {
            String suffix = ((ExtensionFilter)current).getExtension();
            String modifiedPath = Extension.replace(file.getPath(), suffix);
            result = new File(modifiedPath);
            this.chooser.setSelectedFile(result);
        }
        return result;
    }

    private static void writeStrings(File file, String[] args, boolean append) {
        if (file == null || args == null) {
            return;
        }
        BufferedWriter bw = null;
        try {
            try {
                bw = new BufferedWriter(new FileWriter(file, append));
                int j = 0;
                while (j < args.length) {
                    bw.write(args[j]);
                    bw.newLine();
                    ++j;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            if (bw != null) {
                try {
                    bw.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void writeStrings(String[] args) {
        SOSFileIO.writeStrings(this.getSaveTextFile(), args, false);
    }

    public void writeStrings(Collection<String> args) {
        SOSFileIO.writeStrings(this.getSaveTextFile(), args.toArray(new String[0]), false);
    }

    private File getSaveTextFile() {
        this.setFileFilter(txtFilter);
        return this.appendSuffix(this.getSaveFile());
    }

    public ArrayList<String> readStrings() {
        this.setFileFilter(txtFilter);
        File file = this.getOpenFile("Open file...");
        return SOSFileIO.readStrings(file);
    }

    public static ArrayList<String> readStrings(File file) {
        ArrayList<String> stringList = new ArrayList<String>();
        if (file != null && file.canRead()) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(file));
                while ((line = br.readLine()) != null) {
                    stringList.add(line);
                }
                br.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return stringList;
    }

    public File getSelectedFile() {
        return this.chooser.getSelectedFile();
    }

    public static void appendString(File f, String line) {
        SOSFileIO.writeStrings(f, new String[]{line}, true);
    }

    public static void writeStrings(File f, String[] result) {
        SOSFileIO.writeStrings(f, result, false);
    }

    public static void appendStrings(File f, String[] result) {
        SOSFileIO.writeStrings(f, result, true);
    }
}

