/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.image;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class WritableImage {
    private BufferedImage image;
    private boolean enabled = true;

    public void setImage(BufferedImage img) {
        this.image = img;
    }

    public void save(File file, String type) {
        if (!this.enabled || file == null) {
            return;
        }
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByMIMEType(type);
        if (writers.hasNext()) {
            ImageWriter writer = writers.next();
            try {
                try {
                    ImageOutputStream stream = ImageIO.createImageOutputStream(file);
                    writer.setOutput(stream);
                    writer.write(this.image);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            finally {
                writer.dispose();
            }
        }
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    public Image getImage() {
        return this.image;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

