/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.image;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import jp.sourceforge.sos.lib.image.ImageColors;
import jp.sourceforge.sos.lib.image.ImagePixelMediator;
import jp.sourceforge.sos.lib.io.SOSImageIO;
import jp.sourceforge.sos.lib.morphology.connection.AbstractNeighbor;
import jp.sourceforge.sos.lib.morphology.connection.NeighborSimple;

public class LabeledImage {
    private String fileName;
    private AbstractNeighbor neighbor = new NeighborSimple(1, 1);
    private int[] pixels;
    private int[] pixelsColorsTable;
    private int[] labels = new int[1];
    private Image image;
    private int colorNumber;

    public LabeledImage() {
        this.pixelsColorsTable = new int[1];
    }

    public LabeledImage(BufferedImage img) {
        this();
        this.setImage(img);
    }

    public void setImage(Image img) {
        if (img == null) {
            return;
        }
        this.image = img;
        this.setSize(img.getWidth(null), img.getHeight(null));
        this.pixels = ImagePixelMediator.toPixels(img);
    }

    public int getColorNumber() {
        return this.colorNumber;
    }

    public int[] getPixels() {
        return this.pixels;
    }

    public void setSize(int w, int h) {
        if (w != this.neighbor.getWidth() || h != this.neighbor.getHeight()) {
            this.neighbor = new NeighborSimple(w, h);
        }
        if (this.labels.length != this.neighbor.getSize()) {
            this.pixelsColorsTable = new int[this.neighbor.getSize()];
            this.labels = new int[this.neighbor.getSize()];
        }
    }

    public int getWidth() {
        return this.neighbor.getWidth();
    }

    public int getHeight() {
        return this.neighbor.getHeight();
    }

    public int getImageSize() {
        return this.neighbor.getSize();
    }

    public void setName(String name) {
        this.fileName = name;
    }

    public final String getName() {
        return this.fileName;
    }

    public int[] getPixelColorTable() {
        return this.pixelsColorsTable;
    }

    public int getPixelColorTable(int index) {
        return this.pixelsColorsTable[index];
    }

    public AbstractNeighbor getNeighbor() {
        return this.neighbor;
    }

    public void setLabels(int[] colorLabel) {
        int pn = 0;
        while (pn < this.neighbor.getSize()) {
            this.labels[pn] = colorLabel[this.pixelsColorsTable[pn]];
            ++pn;
        }
    }

    public void setPixelsLabel(int index, int value) {
        this.labels[index] = value;
    }

    public void setPixelsLabel(Point p, int value) {
        int index = this.pointToOffset(p);
        if (index >= 0) {
            this.labels[index] = value;
        }
    }

    public int pointToOffset(Point p) {
        if (p.x < 0 || this.getWidth() <= p.x || p.y < 0 || this.getHeight() <= p.y) {
            return -1;
        }
        return p.x + p.y * this.neighbor.getWidth();
    }

    public int[] getLabels() {
        return this.labels;
    }

    public Image getImage() {
        return this.image;
    }

    public BufferedImage createImage(int[] rgb) {
        int[] p = new int[this.pixels.length];
        int pn = 0;
        while (pn < this.pixels.length) {
            p[pn] = this.labels[pn] >= 0 ? rgb[this.labels[pn]] : 0;
            ++pn;
        }
        return ImagePixelMediator.toImage(p, this.getWidth(), this.getHeight());
    }

    public void setFile(File file) {
        if (file == null) {
            return;
        }
        BufferedImage img = SOSImageIO.readImage(file);
        this.setImage(img);
        this.setName(file.getName());
        int i = 0;
        while (i < this.labels.length) {
            this.labels[i] = -1;
            ++i;
        }
    }

    public void fillLabel(int value) {
        Arrays.fill(this.labels, value);
    }

    public Dimension getSize() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public void setNeighbor(AbstractNeighbor neighborFrame) {
        this.neighbor = neighborFrame;
    }

    public void makePixelsColorsTable(ImageColors imageColors) {
        int[] intRGB = imageColors.getIntColors();
        int pn = 0;
        while (pn < this.pixels.length) {
            int index;
            int value = this.pixels[pn] & 0xFFFFFF;
            this.pixelsColorsTable[pn] = index = Arrays.binarySearch(intRGB, value);
            ++pn;
        }
        this.colorNumber = imageColors.getIntColors().length;
    }

    public int[] getLabelCount() {
        int[] result = new int[this.colorNumber];
        int i = 0;
        while (i < this.labels.length) {
            if (this.labels[i] >= 0) {
                int n = this.labels[i];
                result[n] = result[n] + 1;
            }
            ++i;
        }
        return result;
    }
}

