/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.image;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jp.sourceforge.sos.lib.image.ImagePixelMediator;
import jp.sourceforge.sos.lib.io.SOSImageIO;

public class ImageColors {
    private int[] intColors = new int[0];
    private int[] histogram = new int[0];
    private int[] labels;

    public int[] getIntColors() {
        return this.intColors;
    }

    public void setIntColors(int[] colors) {
        this.intColors = colors;
    }

    public int[] getHistogram() {
        return this.histogram;
    }

    public void setHistogram(int[] h) {
        this.histogram = h;
    }

    public void setupFromMap(TreeMap<Integer, Integer> map) {
        if (this.intColors.length != map.size()) {
            this.intColors = new int[map.size()];
            this.histogram = new int[map.size()];
        }
        Set<Integer> keys = map.keySet();
        int count = 0;
        for (Integer i : keys) {
            this.intColors[count] = i;
            this.histogram[count] = map.get(i);
            ++count;
        }
    }

    public void makeMap(File file, Map<Integer, Integer> map) {
        BufferedImage img = SOSImageIO.readImage(file);
        if (img != null) {
            int[] pixels = ImagePixelMediator.toPixels(img);
            this.makeHistogram(pixels, map);
        }
    }

    public void makeHistogram(int[] pixels, Map<Integer, Integer> map) {
        int pi = 0;
        while (pi < pixels.length) {
            int key = pixels[pi] & 0xFFFFFF;
            Integer value = map.get(key);
            int newValue = value == null ? 1 : value + 1;
            map.put(key, newValue);
            ++pi;
        }
    }

    public void setLabels(int[] labels) {
        this.labels = labels;
    }

    public int[] getLabels() {
        return this.labels;
    }
}

