/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.graphics.shape;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import jp.sourceforge.sos.lib.canvas.JObjectCanvas;
import jp.sourceforge.sos.lib.graphics.shape.GraphicsRectangle;
import jp.sourceforge.sos.lib.graphics.shape.Handles;
import jp.sourceforge.sos.lib.graphics.shape.IShape;

public class InteractiveRectangle
implements IShape,
MouseMotionListener,
MouseListener {
    private Handles handles;
    protected GraphicsRectangle rect;
    private JObjectCanvas canvas;
    boolean resizing;
    Point dragPoint;

    public InteractiveRectangle(JObjectCanvas canvas) {
        this.canvas = canvas;
        this.handles = new Handles(this);
        this.rect = new GraphicsRectangle();
        this.dragPoint = new Point();
        this.addListeners();
    }

    public void setColor(Color color) {
        this.rect.setColor(color);
        this.handles.setColor(color);
    }

    @Override
    public void setVisible(boolean b) {
        this.rect.setVisible(b);
        this.handles.setVisible(b);
    }

    public boolean isVisible() {
        return this.rect.isVisible();
    }

    @Override
    public void draw(Graphics g) {
        this.rect.draw(g);
        this.handles.draw(g);
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (this.resizing) {
            this.resizeWithDrag(e.getPoint());
        } else {
            this.translate(e.getPoint());
        }
        this.canvas.repaint();
    }

    public void resizeWithDrag(Point p) {
        int x = Math.min(this.dragPoint.x, p.x);
        int y = Math.min(this.dragPoint.y, p.y);
        int width = Math.abs(this.dragPoint.x - p.x);
        int height = Math.abs(this.dragPoint.y - p.y);
        this.rect.setBounds(x, y, width, height);
    }

    private void translate(Point p) {
        int dx = p.x - this.dragPoint.x;
        int dy = p.y - this.dragPoint.y;
        this.rect.translate(dx, dy);
        this.dragPoint.setLocation(p.x, p.y);
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.handles.mousePressed(e.getPoint());
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public Rectangle getBounds() {
        return this.rect.getBounds();
    }

    @Override
    public boolean contains(Point p) {
        return this.rect.contains(p);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.rect.setBounds(x, y, width, height);
    }

    public void addListeners() {
        this.canvas.addMouseListener(this);
        this.canvas.addMouseMotionListener(this);
    }

    public void setEnabledHandles(boolean b) {
        this.handles.setEnabled(b);
    }
}

