/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.graphics.shape;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import jp.sourceforge.sos.lib.graphics.shape.GraphicsPointRect;
import jp.sourceforge.sos.lib.graphics.shape.InteractiveRectangle;

class Handles {
    private GraphicsPointRect[] points;
    private boolean enabled;
    private InteractiveRectangle rect;

    Handles(InteractiveRectangle rect) {
        this.rect = rect;
        this.enabled = false;
        this.points = new GraphicsPointRect[4];
        int i = 0;
        while (i < this.points.length) {
            this.points[i] = new GraphicsPointRect();
            this.points[i].setFillRect(true);
            ++i;
        }
    }

    public void setEnabled(boolean b) {
        this.enabled = b;
    }

    public void setVisible(boolean b) {
        int i = 0;
        while (i < this.points.length) {
            this.points[i].setVisible(b);
            ++i;
        }
    }

    public void setColor(Color color) {
        int i = 0;
        while (i < this.points.length) {
            this.points[i].setRectColor(color);
            ++i;
        }
    }

    public void draw(Graphics g) {
        if (this.enabled) {
            this.fitPointsToShape();
            int i = 0;
            while (i < this.points.length) {
                this.points[i].draw(g);
                ++i;
            }
        }
    }

    public void mousePressed(Point p) {
        if (this.enabled) {
            this.rect.resizing = this.getOppositeHandle(p);
            this.rect.setVisible(true);
        } else {
            this.rect.dragPoint.setLocation(p.x, p.y);
            this.rect.resizing = true;
        }
    }

    private boolean getOppositeHandle(Point p) {
        int i = 0;
        while (i < this.points.length) {
            if (this.points[i].contains(p)) {
                this.setOppositePoint(i);
                return true;
            }
            ++i;
        }
        this.rect.dragPoint.setLocation(p.x, p.y);
        return !this.rect.getBounds().contains(p);
    }

    private void setOppositePoint(int i) {
        int index = (i + 2) % 4;
        Point p = this.points[index].getLocation();
        this.rect.dragPoint.setLocation(p.x, p.y);
    }

    private void fitPointsToShape() {
        Rectangle r = this.rect.getBounds();
        this.points[0].setLocation(r.x, r.y);
        this.points[1].setLocation(r.x + r.width, r.y);
        this.points[2].setLocation(r.x + r.width, r.y + r.height);
        this.points[3].setLocation(r.x, r.y + r.height);
    }
}

