/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.graphics.shape;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import jp.sourceforge.sos.lib.graphics.shape.IShape;

public class GraphicsRectangle
implements IShape {
    private Rectangle bounds;
    private boolean visible = true;
    private Color color;
    private Mode paintMode;

    public GraphicsRectangle() {
        this(new Rectangle());
    }

    public GraphicsRectangle(Rectangle rect) {
        this.bounds = rect;
        this.paintMode = Mode.DRAW;
    }

    @Override
    public void draw(Graphics g) {
        if (this.visible) {
            Graphics2D g2d = (Graphics2D)g;
            if (this.color != null) {
                g2d.setColor(this.color);
            }
            switch (this.paintMode) {
                case DRAW: {
                    g2d.draw(this.bounds);
                    break;
                }
                case FILL: {
                    g2d.fill(this.bounds);
                }
            }
        }
    }

    public void setColor(Color color) {
        this.color = color;
    }

    @Override
    public Rectangle getBounds() {
        return this.bounds;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.bounds.setBounds(x, y, width, height);
    }

    public void setBounds(Rectangle r) {
        this.bounds.setBounds(r.x, r.y, r.width, r.height);
    }

    public void replaceBounds(Rectangle r) {
        this.bounds = r;
    }

    @Override
    public void setVisible(boolean b) {
        this.visible = b;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean contains(Point p) {
        return this.bounds.contains(p);
    }

    public void setSize(int width, int height) {
        this.bounds.setSize(width, height);
    }

    public Point getLocation() {
        return this.bounds.getLocation();
    }

    public void setLocation(int x, int y) {
        this.bounds.setLocation(x, y);
    }

    public void setPaintMode(Mode paintMode) {
        this.paintMode = paintMode;
    }

    public void translate(int dx, int dy) {
        this.bounds.translate(dx, dy);
    }

    public static enum Mode {
        DRAW,
        FILL;

    }
}

