/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.graphics.shape;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import jp.sourceforge.sos.lib.graphics.shape.IShape;

public class GraphicsPointRect
implements IShape {
    private static final int DEFAULT_RECT_SIZE = 5;
    private int rectSize;
    private int halfSize;
    private Point point;
    private Rectangle rect;
    private boolean visible = true;
    private boolean drawBounds;
    private boolean fillRect;
    private Color boundsColor;
    private Color rectColor;

    public GraphicsPointRect() {
        this(new Point(), 5);
    }

    public GraphicsPointRect(int x, int y) {
        this(new Point(x, y), 5);
    }

    public GraphicsPointRect(int x, int y, int size) {
        this(new Point(x, y), size);
    }

    public GraphicsPointRect(Point p, int size) {
        this.point = p;
        this.rect = new Rectangle();
        this.setSize(size);
    }

    public void setSize(int value) {
        this.rectSize = value;
        this.halfSize = value / 2;
        this.rect.setBounds(this.point.x - this.halfSize, this.point.y - this.halfSize, this.rectSize, this.rectSize);
    }

    public void setLocation(int x, int y) {
        this.point.setLocation(x, y);
        this.rect.x = x - this.halfSize;
        this.rect.y = y - this.halfSize;
    }

    public void setLocation(Point p) {
        this.setLocation(p.x, p.y);
    }

    public Point getLocation() {
        return this.point;
    }

    @Override
    public void draw(Graphics g) {
        if (this.visible) {
            this.fillRect(g);
            this.drawBounds(g);
        }
    }

    private void drawBounds(Graphics g) {
        if (this.drawBounds) {
            if (this.boundsColor != null) {
                g.setColor(this.boundsColor);
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.draw(this.rect);
        }
    }

    private void fillRect(Graphics g) {
        if (this.fillRect) {
            if (this.rectColor != null) {
                g.setColor(this.rectColor);
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.fill(this.rect);
        }
    }

    public void setDrawBounds(boolean draw) {
        this.drawBounds = draw;
    }

    public void setBoundsColor(Color color) {
        this.boundsColor = color;
    }

    public void setFillRect(boolean draw) {
        this.fillRect = draw;
    }

    public void setRectColor(Color color) {
        this.rectColor = color;
    }

    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public boolean contains(Point2D p) {
        return this.rect.contains(p);
    }

    @Override
    public Rectangle getBounds() {
        return this.rect;
    }

    @Override
    public boolean contains(Point p) {
        return this.rect.contains(p);
    }
}

