/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.graphics;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import jp.sourceforge.sos.lib.canvas.IGraphicsContainer;
import jp.sourceforge.sos.lib.graphics.AbstractGraphics;
import jp.sourceforge.sos.lib.graphics.GraphicsArrayList;
import jp.sourceforge.sos.lib.graphics.IGraphics;

public class GraphicsOffscreen
extends AbstractGraphics
implements IGraphicsContainer {
    private BufferedImage imgOffscreen;
    private GraphicsArrayList graphicObjects = new GraphicsArrayList();

    @Override
    public void draw(Graphics g) {
        if (this.visible) {
            g.drawImage(this.imgOffscreen, 0, 0, null);
        }
    }

    public void create(int width, int height) {
        this.imgOffscreen = new BufferedImage(width, height, 2);
    }

    public void update() {
        if (this.imgOffscreen != null) {
            Graphics g = this.imgOffscreen.getGraphics();
            int i = 0;
            while (i < this.graphicObjects.size()) {
                ((IGraphics)this.graphicObjects.get(i)).draw(g);
                ++i;
            }
        }
    }

    @Override
    public void addGraphicObject(IGraphics obj) {
        this.graphicObjects.add(obj);
        this.update();
    }

    @Override
    public void addGraphicObject(int i, IGraphics obj) {
        this.graphicObjects.add(i, obj);
        this.update();
    }

    @Override
    public int getObjectsSize() {
        return this.graphicObjects.size();
    }

    @Override
    public IGraphics getGraphicObject(int index) {
        return (IGraphics)this.graphicObjects.get(index);
    }

    @Override
    public void removeGraphicObject(IGraphics graphicComponent) {
        this.graphicObjects.remove(graphicComponent);
    }

    @Override
    public void removeGraphicObject(int index) {
        this.graphicObjects.remove(index);
    }

    @Override
    public void clearGraphicObject() {
        this.graphicObjects.clear();
    }
}

