/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.graphics;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import jp.sourceforge.sos.lib.graphics.AbstractGraphics;

public class GraphicsLayeredImage
extends AbstractGraphics {
    private ArrayList<BufferedImage> imageArray = new ArrayList();
    private BufferedImage image;

    public void add(BufferedImage img) {
        this.imageArray.add(img);
        this.updateImage();
    }

    public void add(int index, BufferedImage img) {
        this.imageArray.add(index, img);
        this.updateImage();
    }

    public void set(int index, BufferedImage img) {
        this.imageArray.set(index, img);
        this.updateImage();
    }

    private void updateImage() {
        this.checkImage();
        this.overlayImage();
    }

    private void checkImage() {
        if (this.image == null && this.imageArray.size() > 0) {
            BufferedImage img = this.imageArray.get(0);
            this.image = new BufferedImage(img.getWidth(), img.getHeight(), 2);
        }
    }

    private void overlayImage() {
        Graphics g = this.image.getGraphics();
        int i = 0;
        while (i < this.imageArray.size()) {
            g.drawImage(this.imageArray.get(i), 0, 0, null);
            ++i;
        }
        g.dispose();
    }

    @Override
    public void draw(Graphics g) {
        g.drawImage(this.image, 0, 0, null);
    }
}

