/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.color;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import jp.sourceforge.sos.lib.color.ColorModel;
import jp.sourceforge.sos.lib.color.IChoosable;
import jp.sourceforge.sos.lib.variablePanel.IVariableCanvas;
import jp.sourceforge.sos.lib.variablePanel.IVariableModel;

public class JCanvasColor
extends JPanel
implements IChoosable,
IVariableCanvas {
    private static final long serialVersionUID = -7453424644149773201L;
    private static final Color UNENABLE_COLOR = new Color(156, 154, 156);
    private ColorModel colorModel;
    private boolean choosable;
    private String label;

    public JCanvasColor() {
        this(new ColorModel());
    }

    public JCanvasColor(ColorModel model) {
        this.setPreferredSize(new Dimension(100, 15));
        this.choosable = true;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                JCanvasColor.this.showJColorChooser();
            }
        });
        this.setModel(model);
    }

    private void showJColorChooser() {
        if (this.isEnabled() && this.choosable) {
            Color newColor = JColorChooser.showDialog(this, "Choose color...", this.colorModel.getColor());
            this.colorModel.setColor(newColor);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.isEnabled()) {
            g.setColor(Color.black);
        } else {
            g.setColor(UNENABLE_COLOR);
        }
        g.drawString(this.colorModel.getColorString(), 20, 11);
        g.drawLine(0, 0, 14, 0);
        g.drawLine(0, 0, 0, 14);
        g.setColor(this.colorModel.getColor());
        g.fillRect(1, 1, 14, 14);
        g.dispose();
    }

    @Override
    public void setChoosable(boolean colorChoosable) {
        this.choosable = colorChoosable;
    }

    public void update(Object arg) {
        this.repaint();
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    public ColorModel getModel() {
        return this.colorModel;
    }

    public Color getColor() {
        return this.colorModel.getColor();
    }

    public void setColor(Color color) {
        this.colorModel.setColor(color);
    }

    @Override
    public void setModel(IVariableModel model) {
        this.colorModel = (ColorModel)model;
        this.colorModel.addObserver(this);
    }
}

