/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.color;

import java.awt.Color;
import jp.sourceforge.sos.lib.color.ColorModel;
import jp.sourceforge.sos.lib.variablePanel.AbstractPanelModel;

public class ColorPanelModel
extends AbstractPanelModel<ColorModel> {
    private String name;
    private boolean randomColor;

    public ColorPanelModel(String arg) {
        this.name = arg;
        this.randomColor = false;
    }

    public ColorPanelModel() {
    }

    public String toString() {
        return this.name;
    }

    @Override
    protected ColorModel createModel() {
        if (this.randomColor) {
            int value = (int)(Math.random() * 2.147483647E9);
            return new ColorModel(value);
        }
        return new ColorModel();
    }

    public void clearColor() {
        int i = 0;
        while (i < this.getNumber()) {
            ((ColorModel)this.get(i)).setColor(Color.black);
            ++i;
        }
    }

    public void updateColor(int index, Color color) {
        ((ColorModel)this.get(index)).setColor(color);
    }

    public void updateColor(int index, int[] data) {
        ((ColorModel)this.get(index)).setColor(data);
    }

    public void updateColor(int[][] data) {
        int n = Math.min(data.length, this.getNumber());
        int i = 0;
        while (i < n) {
            ((ColorModel)this.get(i)).setColor(data[i]);
            ++i;
        }
    }

    public void updateColor(int[] dataInt) {
        int i = 0;
        while (i < dataInt.length) {
            ((ColorModel)this.get(i)).setColor(dataInt[i]);
            ++i;
        }
    }

    public Color getColor(int index) {
        return ((ColorModel)this.get(index)).getColor();
    }

    public Color[] getColor() {
        Color[] result = new Color[this.getNumber()];
        int i = 0;
        while (i < result.length) {
            result[i] = this.getColor(i);
            ++i;
        }
        return result;
    }

    public int getColorInt(int index) {
        return this.getColor(index).getRGB();
    }

    public int[] getColorInt() {
        int[] array = new int[this.getNumber()];
        int i = 0;
        while (i < array.length) {
            array[i] = this.getColorInt(i);
            ++i;
        }
        return array;
    }

    public String getColorString(int index) {
        return ((ColorModel)this.get(index)).getColorString();
    }

    public void setName(String string) {
        this.name = string;
    }

    public void updateColor(Color[] color) {
        int n = Math.min(color.length, this.getNumber());
        int i = 0;
        while (i < n) {
            ((ColorModel)this.get(i)).setColor(color[i].getRGB());
            ++i;
        }
    }

    public int[][] getColorArray() {
        Color[] colors = this.getColor();
        boolean isTransparent = false;
        int i = 0;
        while (i < colors.length) {
            if (colors[i].getAlpha() < 255) {
                isTransparent = true;
                break;
            }
            ++i;
        }
        if (isTransparent) {
            return this.getTransparentColorArray();
        }
        return this.getColorsArray();
    }

    private int[][] getColorsArray() {
        int[][] result = new int[this.getNumber()][3];
        int i = 0;
        while (i < result.length) {
            this.setRGB(this.getColor(i), result[i]);
            ++i;
        }
        return result;
    }

    private int[][] getTransparentColorArray() {
        int[][] result = new int[this.getNumber()][4];
        int i = 0;
        while (i < result.length) {
            Color color = this.getColor(i);
            this.setRGB(color, result[i]);
            result[i][3] = color.getAlpha();
            ++i;
        }
        return result;
    }

    private void setRGB(Color color, int[] result) {
        result[0] = color.getRed();
        result[1] = color.getGreen();
        result[2] = color.getBlue();
    }

    public void setRandomColor(boolean randomColor) {
        this.randomColor = randomColor;
    }
}

