/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.color;

import java.awt.Color;
import jp.sourceforge.sos.lib.variablePanel.AbstractVariableModel;

public class ColorModel
extends AbstractVariableModel {
    private Color color;
    private int alpha = 255;

    public ColorModel() {
        this(0);
    }

    public ColorModel(int i) {
        this.color = new Color(i);
    }

    public Color getColor() {
        return this.color;
    }

    public int getColorInt() {
        return this.color.getRGB();
    }

    public void setColor(int data) {
        int argb = this.alpha << 24 | data & 0xFFFFFF;
        this.color = new Color(argb, true);
        this.observers.notify(null);
    }

    public void setColor(int[] data) {
        int value = data[0] << 16 | data[1] << 8 | data[2];
        this.setColor(value);
    }

    public void setColor(Color color) {
        this.setColor(color.getRGB());
    }

    public void setAlpha(int value) {
        this.alpha = value;
        this.setColor(this.color.getRGB());
    }

    public String getColorString() {
        return "(" + this.color.getRed() + "," + this.color.getGreen() + "," + this.color.getBlue() + ")";
    }
}

