/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.canvas;

import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import jp.sourceforge.sos.lib.canvas.JObjectCanvas;
import jp.sourceforge.sos.lib.canvas.PointerManager;
import jp.sourceforge.sos.lib.canvas.SizeManager;
import jp.sourceforge.sos.lib.canvas.Transform;
import jp.sourceforge.sos.lib.graphics.GraphicsTransform;

public class JTransformCanvas
extends JObjectCanvas
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    protected SizeManager sizeManager = new SizeManager();
    private PointerManager pointerManager = new PointerManager();
    protected Transform transform;

    public JTransformCanvas() {
        this(new Transform());
    }

    public JTransformCanvas(Transform transform) {
        this.transform = transform;
        this.addGraphicObject(new GraphicsTransform(transform.getAffineTransform()));
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.sizeManager.resized(width, height);
        if (this.transform != null) {
            this.transform.setDestSize(width, height);
            this.transform.translateScreen(this.sizeManager.deltaWidth, this.sizeManager.deltaHeight);
        }
    }

    public void setSourceSize(Dimension dim) {
        this.setSourceSize(dim.width, dim.height);
    }

    public void setSourceSize(int width, int height) {
        this.transform.setSourceSize(width, height);
    }

    public void setTransform(Transform graphicsTransform) {
        this.transform = graphicsTransform;
    }

    public Transform getTransform() {
        return this.transform;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        int modifier = evt.getModifiers();
        double rate = 2.0;
        if ((modifier & 8) != 0 || (modifier & 4) != 0) {
            rate = 0.5;
        }
        this.transform.scale(rate, evt.getX(), evt.getY());
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        this.pointerManager.move(evt.getX(), evt.getY());
        this.transform.translateScreen(this.pointerManager.deltaX, this.pointerManager.deltaY);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.pointerManager.move(evt.getX(), evt.getY());
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent evt) {
        double ratio = 1.0 + (double)evt.getWheelRotation() * 0.05;
        this.transform.scale(ratio);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public int getSourceHeight() {
        return this.transform.getSourceHeight();
    }

    public int getSourceWidth() {
        return this.transform.getSourceWidth();
    }
}

