/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.canvas;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jp.sourceforge.sos.lib.canvas.IGraphicsContainer;
import jp.sourceforge.sos.lib.graphics.GraphicsArrayList;
import jp.sourceforge.sos.lib.graphics.IGraphics;

public class JObjectCanvas
extends JPanel
implements IGraphicsContainer {
    GraphicsArrayList graphicObjects = new GraphicsArrayList();

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.graphicObjects.draw(g);
        g.dispose();
    }

    @Override
    public int getObjectsSize() {
        return this.graphicObjects.size();
    }

    @Override
    public IGraphics getGraphicObject(int index) {
        return (IGraphics)this.graphicObjects.get(index);
    }

    @Override
    public void addGraphicObject(IGraphics graphicComponent) {
        this.graphicObjects.add(graphicComponent);
    }

    @Override
    public void addGraphicObject(int index, IGraphics graphicComponent) {
        this.graphicObjects.add(index, graphicComponent);
    }

    @Override
    public void removeGraphicObject(IGraphics graphicComponent) {
        this.graphicObjects.remove(graphicComponent);
    }

    @Override
    public void removeGraphicObject(int index) {
        this.graphicObjects.remove(index);
    }

    @Override
    public void clearGraphicObject() {
        this.graphicObjects.clear();
    }

    @Override
    public void setSize(int x, int y) {
        super.setSize(x, y);
        this.setPreferredSize(new Dimension(x, y));
    }

    public void repaintLater() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JObjectCanvas.this.repaint();
            }
        });
    }

    public BufferedImage getScreenImage() {
        BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        this.graphicObjects.draw(img.getGraphics());
        return img;
    }
}

