/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.canvas;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Point2D;
import javax.swing.JFrame;
import javax.swing.JLayeredPane;
import jp.sourceforge.sos.lib.image.ImageTransform;

public class JLayeredCanvas
extends JLayeredPane
implements ComponentListener {
    private JFrame frame;
    private ImageTransform imageTransform;
    private FILL fill = FILL.BOTH;
    private boolean sizeLinked = true;

    public JLayeredCanvas(JFrame frame) {
        this.frame = frame;
        this.addComponentListener(this);
    }

    public void setImageTransform(ImageTransform imageTransform) {
        this.imageTransform = imageTransform;
    }

    public Point2D inverseTransform(Point point) {
        return this.imageTransform.inverseTransform(point);
    }

    public Shape inverseTransform(Rectangle rect) {
        return this.imageTransform.inverseTransform(rect);
    }

    @Override
    public Component add(Component comp) {
        if (this.sizeLinked) {
            comp.addComponentListener(this);
        }
        return super.add(comp);
    }

    @Override
    public void componentResized(ComponentEvent e) {
        Component c = e.getComponent();
        Dimension size = this.calcSize(c.getSize());
        int i = 0;
        while (i < this.getComponentCount()) {
            Component comp = this.getComponent(i);
            comp.setSize(size);
            ++i;
        }
        this.setPreferredSize(size);
        this.frame.pack();
    }

    private Dimension calcSize(Dimension size) {
        Dimension result = new Dimension(size.width, size.height);
        switch (this.fill) {
            case NONE: {
                break;
            }
            case HORIZONTAL: {
                this.adjustWidth(result);
                break;
            }
            case VERTICAL: {
                this.adjustHeight(result);
                break;
            }
            case BOTH: {
                this.adjustWidth(result);
                this.adjustHeight(result);
            }
        }
        return result;
    }

    private void adjustHeight(Dimension result) {
        if (this.getHeight() > result.height) {
            result.height = this.getHeight();
        }
    }

    private void adjustWidth(Dimension result) {
        if (this.getWidth() > result.width) {
            result.width = this.getWidth();
        }
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public int getCoreWidth() {
        return this.imageTransform.getImageWidth();
    }

    public int getCoreHeight() {
        return this.imageTransform.getImageHeight();
    }

    public void setSizeLinked(boolean sizeLinked) {
        this.sizeLinked = sizeLinked;
    }

    public static enum FILL {
        NONE,
        HORIZONTAL,
        VERTICAL,
        BOTH;

    }
}

