/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.lib.canvas;

import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import jp.sourceforge.sos.lib.canvas.JObjectCanvas;
import jp.sourceforge.sos.lib.canvas.PointerManager;
import jp.sourceforge.sos.lib.canvas.SizeManager;
import jp.sourceforge.sos.lib.image.ImageTransform;

public class JImageCanvas
extends JObjectCanvas
implements MouseListener,
MouseMotionListener,
MouseWheelListener {
    protected SizeManager sizeManager = new SizeManager();
    private PointerManager pointerManager = new PointerManager();
    protected ImageTransform imageTransform;

    public JImageCanvas() {
        this(new ImageTransform());
    }

    public JImageCanvas(ImageTransform imageTransform) {
        this.imageTransform = imageTransform;
        this.addGraphicObject(imageTransform);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.sizeManager.resized(width, height);
        if (this.imageTransform != null) {
            this.imageTransform.setDestSize(width, height);
            this.imageTransform.translateScreen(this.sizeManager.deltaWidth, this.sizeManager.deltaHeight);
        }
    }

    public void setImage(Image img) {
        this.imageTransform.setDestSize(this.getWidth(), this.getHeight());
        this.imageTransform.setImage(img);
    }

    @Override
    public BufferedImage getScreenImage() {
        BufferedImage img = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        this.imageTransform.draw(img.getGraphics());
        return img;
    }

    public void setImageTransform(ImageTransform imageTransform) {
        this.imageTransform = imageTransform;
    }

    public ImageTransform getImageTransform() {
        return this.imageTransform;
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        int modifier = evt.getModifiers();
        double rate = 2.0;
        if ((modifier & 8) != 0 || (modifier & 4) != 0) {
            rate = 0.5;
        }
        this.imageTransform.scaleImage(rate, evt.getX(), evt.getY());
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
        this.pointerManager.move(evt.getX(), evt.getY());
        this.imageTransform.translateScreen(this.pointerManager.deltaX, this.pointerManager.deltaY);
    }

    @Override
    public void mousePressed(MouseEvent evt) {
        this.pointerManager.move(evt.getX(), evt.getY());
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent evt) {
        double ratio = 1.0 + (double)evt.getWheelRotation() * 0.05;
        this.imageTransform.scaleImage(ratio);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public int getImageHeight() {
        return this.imageTransform.getImageHeight();
    }

    public int getImageWidth() {
        return this.imageTransform.getImageWidth();
    }

    public Image getImage() {
        return this.imageTransform.getSourceImage();
    }
}

