/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.resultImage;

import java.awt.Rectangle;
import java.io.File;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import jp.sourceforge.sos.cytoq.AbstractAlgorithm;
import jp.sourceforge.sos.cytoq.colorFinal.ModelColorFinal;
import jp.sourceforge.sos.cytoq.main.AbstractFileHandler;
import jp.sourceforge.sos.cytoq.message.IAnimation;
import jp.sourceforge.sos.cytoq.message.IEndSection;
import jp.sourceforge.sos.cytoq.message.IInitProcess;
import jp.sourceforge.sos.cytoq.message.IInitSection;
import jp.sourceforge.sos.cytoq.message.IResize;
import jp.sourceforge.sos.cytoq.resultImage.AbstractResultImage;
import jp.sourceforge.sos.cytoq.resultImage.ImageColorPanel;
import jp.sourceforge.sos.cytoq.resultImage.ImageOriginal;
import jp.sourceforge.sos.framework.model.AbstractModel;
import jp.sourceforge.sos.lib.color.ColorPanelModel;
import jp.sourceforge.sos.lib.image.LabeledImage;
import jp.sourceforge.sos.lib.io.Extension;
import jp.sourceforge.sos.lib.window.JImageArrayFrame;

public class ModelResultImage
extends AbstractModel<ModelColorFinal>
implements IInitProcess,
IInitSection,
IAnimation,
IEndSection,
IResize {
    private AbstractResultImage[] resultImages = new AbstractResultImage[3];
    private JImageArrayFrame frame = new JImageArrayFrame();
    private double magnification;
    private String pathSave;
    private int indexAnimation;

    @Override
    protected void initModel() {
        this.resultImages[0] = new ImageOriginal("Original");
        this.resultImages[1] = new ImageColorPanel(((ModelColorFinal)this.modelParent).getInitColors());
        this.resultImages[2] = new ImageColorPanel(((ModelColorFinal)this.modelParent).getColorModel());
        this.setIndexAnimation(1);
        int i = 0;
        while (i < this.resultImages.length) {
            this.frame.addImage(this.resultImages[i]);
            ++i;
        }
        this.resultImages[0].setPrefix("");
        this.resultImages[1].setPrefix("(INIT)");
        this.resultImages[2].setPrefix("(FINAL)");
    }

    @Override
    public void observeInitSection(AbstractAlgorithm changed) {
        LabeledImage image = changed.getLabeledImage();
        this.frame.clearImage();
        this.frame.addImage(this.resultImages[this.indexAnimation]);
        this.frame.updateScrollBar();
        int w = (int)(this.magnification * (double)image.getWidth());
        int h = (int)(this.magnification * (double)image.getHeight());
        this.frame.setCanvasSize(w, h);
        this.frame.pack();
        this.frame.setVisible(true);
    }

    @Override
    public void observeAnimation(AbstractAlgorithm changed) {
        this.resultImages[this.indexAnimation].createImage(changed.getLabeledImage());
        this.frame.setCurrentImage(0);
    }

    @Override
    public void observeEndSection(AbstractAlgorithm changed) {
        this.frame.clearImage();
        int i = 0;
        while (i < this.resultImages.length) {
            if (this.resultImages[i].isEnabled()) {
                this.resultImages[i].createImage(changed.getLabeledImage());
                this.frame.addImage(this.resultImages[i]);
            }
            ++i;
        }
        this.frame.updateScrollBar();
        this.saveImages(changed.getName());
    }

    private void saveImages(String name) {
        if (this.pathSave == null) {
            return;
        }
        int i = 1;
        while (i < this.resultImages.length) {
            if (this.resultImages[i].isEnabled()) {
                StringBuilder builder = new StringBuilder();
                builder.append(this.pathSave);
                builder.append(this.resultImages[i].getPrefix());
                builder.append(Extension.replace(name, "png"));
                File file = new File(builder.toString());
                this.resultImages[i].save(file, "image/png");
            }
            ++i;
        }
    }

    public void setMagnification(double value) {
        this.magnification = value;
    }

    ComboBoxModel getColorsModel() {
        DefaultComboBoxModel<ColorPanelModel> model = new DefaultComboBoxModel<ColorPanelModel>();
        model.addElement(((ModelColorFinal)this.modelParent).getInitColors());
        model.addElement(((ModelColorFinal)this.modelParent).getColorModel());
        return model;
    }

    public void setIndexAnimation(int index) {
        this.indexAnimation = index;
    }

    @Override
    public void observeResize(Rectangle changed) {
        this.frame.setLocation(changed.x + changed.width, changed.y);
    }

    @Override
    public void observeInitProcess(AbstractFileHandler changed) {
        this.pathSave = changed.getPath();
    }

    public void setImageEnabled(int i, boolean b) {
        this.resultImages[i].setEnabled(b);
    }
}

