/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.result;

import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import jp.sourceforge.sos.cytoq.IVariable;
import jp.sourceforge.sos.cytoq.colorInit.ModelColorInit;
import jp.sourceforge.sos.cytoq.result.variables.VariableMulti;
import jp.sourceforge.sos.framework.IInitialize;
import jp.sourceforge.sos.framework.model.AbstractModel;
import jp.sourceforge.sos.framework.pattern.IObserver;
import jp.sourceforge.sos.lib.color.ColorModel;
import jp.sourceforge.sos.lib.io.SOSFileIO;
import jp.sourceforge.sos.lib.window.DoubleListModel;
import jp.sourceforge.sos.lib.window.ListComboBoxModel;

public class ModelResult
extends AbstractModel<ModelColorInit>
implements IInitialize,
IObserver<ColorModel> {
    private SOSFileIO fileIO = new SOSFileIO();
    private DefaultTableModel tableModelResult = new DefaultTableModel();
    private ListComboBoxModel comboModelHeader = new ListComboBoxModel();
    private DoubleListModel<IVariable> selections = new DoubleListModel();

    private void setHeader() {
        this.comboModelHeader.clear();
        int i = 0;
        while (i < this.selections.getSizeSelection()) {
            this.selections.getSelectionItem(i).toHeader(this.comboModelHeader);
            ++i;
        }
    }

    public ComboBoxModel getComboModelHeader() {
        this.setHeader();
        return this.comboModelHeader;
    }

    public void updateHeader() {
        this.setHeader();
        this.tableModelResult.setColumnIdentifiers(this.comboModelHeader.toArray());
    }

    DoubleListModel getSelections() {
        return this.selections;
    }

    TableModel getTableModel() {
        return this.tableModelResult;
    }

    void clear() {
        this.tableModelResult.setRowCount(0);
    }

    void save() {
        String[] result = new String[this.tableModelResult.getRowCount()];
        int i = 0;
        while (i < result.length) {
            StringBuilder builder = new StringBuilder();
            int j = 0;
            while (j < this.tableModelResult.getColumnCount()) {
                builder.append(this.tableModelResult.getValueAt(i, j));
                builder.append(",");
                ++j;
            }
            result[i] = builder.toString();
            ++i;
        }
        this.fileIO.writeStrings(result);
    }

    @Override
    protected void initModel() {
        ((ModelColorInit)this.modelParent).addObserverInitColor(this);
    }

    public String getDataFromHeader(String name) {
        int column = -1;
        int i = 0;
        while (i < this.comboModelHeader.size()) {
            String arg = (String)this.comboModelHeader.get(i);
            if (arg.equals(name)) {
                column = i;
                break;
            }
            ++i;
        }
        if (column == -1) {
            return null;
        }
        int row = this.tableModelResult.getRowCount() - 1;
        return (String)this.tableModelResult.getValueAt(row, column);
    }

    @Override
    public void init() {
        int i = 0;
        while (i < this.selections.getSizePreset()) {
            this.selections.selectFromPreset(i);
            ++i;
        }
        this.updateHeader();
    }

    public DefaultListModel getPresets() {
        return (DefaultListModel)this.selections.getModelPreset();
    }

    public void addResult() {
        Vector<String> result = new Vector<String>();
        int i = 0;
        while (i < this.selections.getSizeSelection()) {
            this.selections.getSelectionItem(i).toResult(result);
            ++i;
        }
        this.tableModelResult.addRow(result);
    }

    @Override
    public void update(ColorModel changed) {
        int n = ((ModelColorInit)this.modelParent).getColorNumber();
        int i = 0;
        while (i < this.selections.getSizeSelection()) {
            IVariable variable = this.selections.getSelectionItem(i);
            if (variable instanceof VariableMulti) {
                ((VariableMulti)variable).setNumber(n);
            }
            ++i;
        }
        this.updateHeader();
    }
}

