/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.main;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.sourceforge.sos.cytoq.main.ModelMain;
import jp.sourceforge.sos.framework.ILinkContainer;
import jp.sourceforge.sos.framework.ILinkModel;
import jp.sourceforge.sos.framework.model.IComponent;
import jp.sourceforge.sos.lib.colorspace.SOSColorSpace;

class ViewPanelOption
extends JPanel
implements ILinkModel,
ILinkContainer {
    private ModelMain modelMain = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JLabel jLabel2 = null;
    private JSpinner jSpinnerIteration = null;
    private JSpinner jSpinnerEPS = null;
    private JSpinner jSpinnerMaxStep = null;
    private JLabel jLabel3 = null;
    private JSpinner jSpinnerAnimation = null;
    private JLabel jLabel11 = null;
    private JComboBox jComboBox = null;

    ViewPanelOption() {
        this.initialize();
    }

    private void initSpinner(JSpinner spinner, int value, int min, int max) {
        SpinnerNumberModel model = new SpinnerNumberModel(min + 1, min, max, 1);
        spinner.setModel(model);
        spinner.setValue(value);
    }

    private void initialize() {
        this.jLabel11 = new JLabel();
        this.jLabel11.setText("color space: ");
        this.jLabel11.setHorizontalAlignment(4);
        this.jLabel3 = new JLabel();
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("animation step: ");
        this.setBorder(BorderFactory.createTitledBorder(null, "Process", 0, 0, null, Color.blue));
        GridLayout gridLayout = new GridLayout();
        gridLayout.setColumns(2);
        gridLayout.setRows(5);
        this.jLabel2 = new JLabel();
        this.jLabel2.setText("max iteration: ");
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel1 = new JLabel();
        this.jLabel1.setText("EPS(decimal): ");
        this.jLabel1.setHorizontalAlignment(4);
        this.jLabel = new JLabel();
        this.jLabel.setText("batch iteration: ");
        this.jLabel.setHorizontalAlignment(4);
        this.setLayout(gridLayout);
        this.add((Component)this.jLabel, null);
        this.add((Component)this.getJSpinnerIteration(), null);
        this.add((Component)this.jLabel1, null);
        this.add((Component)this.getJSpinnerEPS(), null);
        this.add((Component)this.jLabel2, null);
        this.add((Component)this.getJSpinnerMaxStep(), null);
        this.add((Component)this.jLabel3, null);
        this.add((Component)this.getJSpinnerAnimation(), null);
        this.add((Component)this.jLabel11, null);
        this.add((Component)this.getJComboBox(), null);
    }

    private JSpinner getJSpinnerIteration() {
        if (this.jSpinnerIteration == null) {
            this.jSpinnerIteration = new JSpinner();
            this.jSpinnerIteration.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int value = (Integer)ViewPanelOption.this.jSpinnerIteration.getValue();
                    ViewPanelOption.this.modelMain.setMaxSection(value);
                }
            });
        }
        return this.jSpinnerIteration;
    }

    private JSpinner getJSpinnerEPS() {
        if (this.jSpinnerEPS == null) {
            this.jSpinnerEPS = new JSpinner();
            this.jSpinnerEPS.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    double value = Math.pow(0.1, ((Integer)ViewPanelOption.this.jSpinnerEPS.getValue()).intValue());
                    ViewPanelOption.this.modelMain.setEPS(value);
                }
            });
        }
        return this.jSpinnerEPS;
    }

    private JSpinner getJSpinnerMaxStep() {
        if (this.jSpinnerMaxStep == null) {
            this.jSpinnerMaxStep = new JSpinner();
            this.jSpinnerMaxStep.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int value = (Integer)ViewPanelOption.this.jSpinnerMaxStep.getValue();
                    ViewPanelOption.this.modelMain.setMaxStep(value);
                }
            });
        }
        return this.jSpinnerMaxStep;
    }

    private JSpinner getJSpinnerAnimation() {
        if (this.jSpinnerAnimation == null) {
            this.jSpinnerAnimation = new JSpinner();
            this.jSpinnerAnimation.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int value = (Integer)ViewPanelOption.this.jSpinnerAnimation.getValue();
                    ViewPanelOption.this.modelMain.setAnimationStep(value);
                }
            });
        }
        return this.jSpinnerAnimation;
    }

    @Override
    public void setModel(IComponent model) {
        this.modelMain = (ModelMain)model;
        this.initSpinner(this.jSpinnerIteration, 1, 1, 1000);
        this.initSpinner(this.jSpinnerEPS, 7, 0, 16);
        this.initSpinner(this.jSpinnerMaxStep, 1000, 1, Integer.MAX_VALUE);
        this.initSpinner(this.jSpinnerAnimation, 5, 1, Integer.MAX_VALUE);
        this.jComboBox.addItem(SOSColorSpace.getCIELabSpace());
        this.jComboBox.addItem(SOSColorSpace.getRGBSpace());
    }

    @Override
    public String getContainer() {
        return "jPanelOption";
    }

    @Override
    public Object getConstraints() {
        return new Integer(0);
    }

    private JComboBox getJComboBox() {
        if (this.jComboBox == null) {
            this.jComboBox = new JComboBox();
            this.jComboBox.setModel(new DefaultComboBoxModel());
            this.jComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ViewPanelOption.this.setColorSpace();
                }
            });
        }
        return this.jComboBox;
    }

    private void setColorSpace() {
        SOSColorSpace colorSpace = (SOSColorSpace)this.jComboBox.getSelectedItem();
        this.modelMain.setColorSpace(colorSpace);
    }
}

