/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import jp.sourceforge.sos.cytoq.AbstractAlgorithm;
import jp.sourceforge.sos.cytoq.main.AbstractFileHandler;
import jp.sourceforge.sos.cytoq.main.ModelMain;
import jp.sourceforge.sos.cytoq.message.IEndProcess;
import jp.sourceforge.sos.framework.ILinkContainer;
import jp.sourceforge.sos.framework.ILinkModel;
import jp.sourceforge.sos.framework.loader.PluginClassLoader;
import jp.sourceforge.sos.framework.model.IComponent;
import jp.sourceforge.sos.framework.thread.ThreadStatus;
import jp.sourceforge.sos.framework.util.Factory;
import jp.sourceforge.sos.lib.io.Extension;

class ViewPanel
extends JPanel
implements ILinkModel,
ILinkContainer,
IEndProcess {
    private JComboBox jComboAlgorithm = null;
    private JPanel jPanelOption;
    private ModelMain modelMain;
    private JPanel jPanelAlgorithm = null;
    private JButton jButton = null;
    private JComboBox jComboFileHandler = null;
    private JPanel jPanelFile = null;

    public ViewPanel() {
        this.initialize();
    }

    private void loadPlugin() {
        StringBuffer pathBuffer = new StringBuffer(System.getProperty("user.dir"));
        pathBuffer.append(File.separator);
        pathBuffer.append("plugins");
        pathBuffer.append(File.separator);
        pathBuffer.append("segmentation");
        String path = pathBuffer.toString();
        File dir = new File(path);
        PluginClassLoader loader = new PluginClassLoader(path);
        File[] fileList = dir.listFiles();
        if (fileList != null) {
            int i = 0;
            while (i < fileList.length) {
                AbstractAlgorithm algorithm = this.getAlgorithm(loader, fileList[i].getName());
                if (algorithm != null) {
                    this.jComboAlgorithm.addItem(algorithm);
                }
                ++i;
            }
        }
    }

    private AbstractAlgorithm getAlgorithm(PluginClassLoader loader, String algorithmName) {
        if (algorithmName != null) {
            algorithmName = Extension.remove(algorithmName);
            try {
                return (AbstractAlgorithm)loader.loadClass(algorithmName).newInstance();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.add((Component)this.getJPanelAlgorithm(), "Center");
        this.add((Component)this.getJPanelFile(), "South");
    }

    private JComboBox getJComboAlgorithm() {
        if (this.jComboAlgorithm == null) {
            this.jComboAlgorithm = new JComboBox();
            this.jComboAlgorithm.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ViewPanel.this.setAlgorithmOption();
                }
            });
        }
        return this.jComboAlgorithm;
    }

    private void setAlgorithmOption() {
        AbstractAlgorithm algorithm = (AbstractAlgorithm)this.jComboAlgorithm.getSelectedItem();
        if (algorithm != null) {
            algorithm.confineFile(this.jComboFileHandler);
            if (this.jPanelOption != null) {
                this.jPanelAlgorithm.remove(this.jPanelOption);
            }
            this.jPanelOption = algorithm.getOptionPanel();
            if (this.jPanelOption != null) {
                this.jPanelAlgorithm.add((Component)this.jPanelOption, "Center");
            }
            this.jPanelAlgorithm.validate();
            this.modelMain.setAlgorithm(algorithm);
        }
    }

    @Override
    public String getContainer() {
        return "jPanelMain";
    }

    @Override
    public Object getConstraints() {
        return "West";
    }

    @Override
    public void setModel(IComponent model) {
        this.modelMain = (ModelMain)model;
        this.loadPlugin();
        this.setFileHandler();
        this.setAlgorithmOption();
    }

    private JPanel getJPanelAlgorithm() {
        if (this.jPanelAlgorithm == null) {
            this.jPanelAlgorithm = new JPanel();
            this.jPanelAlgorithm.setLayout(new BorderLayout());
            this.jPanelAlgorithm.setBorder(BorderFactory.createTitledBorder(null, "Algorithm", 0, 0, new Font("Dialog", 1, 12), Color.blue));
            this.jPanelAlgorithm.add((Component)this.getJComboAlgorithm(), "North");
        }
        return this.jPanelAlgorithm;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
            this.jButton.setForeground(new Color(102, 102, 255));
            this.jButton.setText(ThreadStatus.START.toString());
            this.jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String arg = ViewPanel.this.modelMain.changeProcessStatus(ViewPanel.this.jButton.getText());
                    ViewPanel.this.jButton.setText(arg);
                }
            });
        }
        return this.jButton;
    }

    private JComboBox getJComboFileHandler() {
        if (this.jComboFileHandler == null) {
            this.jComboFileHandler = new JComboBox();
            Factory.set(this.jComboFileHandler, AbstractFileHandler.class);
            this.jComboFileHandler.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ViewPanel.this.setFileHandler();
                }
            });
        }
        return this.jComboFileHandler;
    }

    private void setFileHandler() {
        AbstractFileHandler handler = (AbstractFileHandler)this.jComboFileHandler.getSelectedItem();
        if (this.modelMain != null) {
            this.modelMain.setFileHandler(handler);
        }
    }

    @Override
    public void observeAnalysisFinish(String changed) {
        this.jButton.setText("START");
    }

    private JPanel getJPanelFile() {
        if (this.jPanelFile == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(2);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 2;
            gridBagConstraints1.gridwidth = 2;
            gridBagConstraints1.gridx = -1;
            gridBagConstraints1.gridy = -1;
            gridBagConstraints1.insets = new Insets(0, 0, 10, 0);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridx = -1;
            this.jPanelFile = new JPanel();
            this.jPanelFile.setLayout(gridLayout);
            this.jPanelFile.setBorder(BorderFactory.createTitledBorder(null, "File", 0, 0, new Font("Dialog", 1, 12), Color.blue));
            this.jPanelFile.add((Component)this.getJComboFileHandler(), null);
            this.jPanelFile.add((Component)this.getJButton(), null);
        }
        return this.jPanelFile;
    }
}

