/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.main;

import java.awt.Rectangle;
import jp.sourceforge.sos.cytoq.AbstractAlgorithm;
import jp.sourceforge.sos.cytoq.main.AbstractFileHandler;
import jp.sourceforge.sos.framework.thread.AbstractThread;
import jp.sourceforge.sos.lib.colorspace.SOSColorSpace;

public class ModelMain
extends AbstractThread {
    private double eps;
    AbstractAlgorithm algorithm;
    AbstractFileHandler fileHandler;
    private SOSColorSpace colorSpace;

    ModelMain() {
    }

    public void setAlgorithm(AbstractAlgorithm plugin) {
        this.algorithm = plugin;
    }

    @Override
    protected void initProcess() {
        super.initProcess();
        this.setMaxSection(this.fileHandler.setFiles());
        this.algorithm.setFileHandler(this.fileHandler);
        this.ready = this.algorithm.initProcess();
    }

    @Override
    protected void initSection() {
        this.algorithm.initSection();
        this.createInput();
        this.algorithm.setDesiredValue(this.eps);
        super.initSection();
    }

    private void createInput() {
        int[] intRGB = this.algorithm.getIntColors();
        double[][] input = new double[intRGB.length][];
        int[] rgb = new int[3];
        int i = 0;
        while (i < intRGB.length) {
            rgb[0] = intRGB[i] >> 16 & 0xFF;
            rgb[1] = intRGB[i] >> 8 & 0xFF;
            rgb[2] = intRGB[i] >> 0 & 0xFF;
            input[i] = this.colorSpace.fromRGB(rgb);
            ++i;
        }
        this.algorithm.setInput(input);
    }

    @Override
    protected void mainLoop() {
        this.algorithm.calculate();
    }

    @Override
    protected void endAnimationStep() {
        int[] label = this.algorithm.getCluster();
        if (label != null) {
            this.algorithm.getLabeledImage().setLabels(label);
        }
    }

    @Override
    protected void endSection() {
        super.endSection();
        this.algorithm.getImageColor().setLabels(this.algorithm.getCluster());
    }

    @Override
    public void endProcess() {
        this.algorithm.endProcess();
    }

    @Override
    protected boolean isConvoluted() {
        return this.algorithm.isConvoluted();
    }

    void setFileHandler(AbstractFileHandler handler) {
        this.fileHandler = handler;
    }

    @Override
    protected void initModel() {
    }

    public void setEPS(double value) {
        this.eps = value;
    }

    public void resized(Rectangle bounds) {
    }

    public int[] getColorLabel() {
        return this.algorithm.getCluster();
    }

    public void setInput(double[][] input) {
        this.algorithm.setInput(input);
    }

    public AbstractAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public int[] getLabelCount() {
        return this.algorithm.getLabeledImage().getLabelCount();
    }

    public void setColorSpace(SOSColorSpace colorSpace) {
        this.colorSpace = colorSpace;
    }

    public SOSColorSpace getColorSpace() {
        return this.colorSpace;
    }
}

