/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.main;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import jp.sourceforge.sos.cytoq.main.AbstractFileHandler;
import jp.sourceforge.sos.lib.io.SOSImageIO;
import jp.sourceforge.sos.lib.window.JProgressDialog;

class FileBatch
extends AbstractFileHandler {
    private File dirSave;
    private Iterator<File> iterator;
    private int fileNumber;
    private File dirOpen;

    FileBatch() {
    }

    @Override
    public int setFiles() {
        this.dirOpen = imageIO.getOpenDirectory();
        if (this.dirOpen == null) {
            return 0;
        }
        this.dirSave = imageIO.getSaveDirectory();
        if (this.dirSave == null) {
            return 0;
        }
        this.extractFiles(this.dirOpen.listFiles());
        return this.fileNumber;
    }

    protected void extractFiles(File[] files) {
        Arrays.sort(files);
        ArrayList<File> filesList = new ArrayList<File>();
        JProgressDialog dialog = new JProgressDialog(null);
        dialog.start("Loading images...", false);
        int i = 0;
        while (i < files.length) {
            BufferedImage img = SOSImageIO.readImage(files[i]);
            if (img != null) {
                filesList.add(files[i]);
            }
            dialog.setValue(100 * i / files.length);
            ++i;
        }
        dialog.stop();
        this.iterator = filesList.iterator();
        this.fileNumber = filesList.size();
    }

    @Override
    public int getOrder() {
        return 1;
    }

    @Override
    public void next() {
        this.currentFile = this.iterator.next();
    }

    @Override
    public String getPath() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.dirSave);
        builder.append(File.separator);
        return builder.toString();
    }

    @Override
    public File getDir() {
        return this.dirOpen;
    }
}

