/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.equation;

import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import jp.sourceforge.sos.cytoq.result.ModelResult;
import jp.sourceforge.sos.framework.IInitialize;
import jp.sourceforge.sos.framework.model.AbstractModel;
import jp.sourceforge.sos.framework.pattern.IObservable;
import jp.sourceforge.sos.framework.pattern.IObserver;
import jp.sourceforge.sos.framework.pattern.ObserverSet;
import jp.sourceforge.sos.lib.math.RevertPolish;

public class ModelEquation
extends AbstractModel<ModelResult>
implements IInitialize,
IObservable<String> {
    private ArrayList<String> equationItems = new ArrayList();
    private DecimalFormat format;
    private ObserverSet<String> observers = new ObserverSet();

    public ModelEquation() {
        this.format = new DecimalFormat();
        this.format.setMaximumFractionDigits(2);
        this.format.setMultiplier(100);
        this.format.setPositiveSuffix("%");
    }

    @Override
    protected void initModel() {
    }

    @Override
    public void init() {
        this.equationItems.add("@Area3");
        this.equationItems.add("/");
        this.equationItems.add("(");
        this.equationItems.add("@Area2");
        this.equationItems.add("+");
        this.equationItems.add("@Area3");
        this.equationItems.add(")");
        this.setEquation();
    }

    private void setEquation() {
        StringBuffer buffer = new StringBuffer("=");
        if (this.equationItems.size() > 0) {
            int i = 0;
            while (i < this.equationItems.size()) {
                String item = this.equationItems.get(i);
                if (item.startsWith("@")) {
                    item = item.substring(1);
                }
                buffer.append(item);
                ++i;
            }
        }
        String result = buffer.toString();
        this.observers.notify(result);
    }

    void remove() {
        int index = this.equationItems.size() - 1;
        if (index >= 0) {
            this.equationItems.remove(index);
            this.setEquation();
        }
    }

    void clear() {
        this.equationItems.clear();
        this.setEquation();
    }

    void appendVariable(String item) {
        this.equationItems.add("@" + item);
        this.setEquation();
    }

    void appendNonVariable(String arg) {
        this.equationItems.add(arg);
        this.setEquation();
    }

    ComboBoxModel getHeader() {
        return ((ModelResult)this.modelParent).getComboModelHeader();
    }

    String calcEquation() {
        ((ModelResult)this.modelParent).addResult();
        StringBuilder equation = new StringBuilder();
        int i = 0;
        while (i < this.equationItems.size()) {
            String item = this.equationItems.get(i);
            if (item.startsWith("@")) {
                item = this.getVaribale(item.substring(1));
            }
            equation.append(item);
            ++i;
        }
        String arg = equation.toString();
        if (arg == null || arg.length() == 0) {
            return "";
        }
        return this.format.format(RevertPolish.calc(arg));
    }

    private String getVaribale(String name) {
        return ((ModelResult)this.modelParent).getDataFromHeader(name);
    }

    @Override
    public void addObserver(IObserver<String> observer) {
        this.observers.addObserver(observer);
    }

    @Override
    public void removeObserver(IObserver<String> observer) {
        this.observers.removeObserver(observer);
    }

    @Override
    public void clearObserver() {
        this.observers.clearObserver();
    }
}

