/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.colorView;

import java.awt.Image;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import javax.swing.JComponent;
import jp.sourceforge.sos.cytoq.AbstractAlgorithm;
import jp.sourceforge.sos.cytoq.colorFinal.ModelColorFinal;
import jp.sourceforge.sos.cytoq.colorView.AbstractCanvas;
import jp.sourceforge.sos.cytoq.colorView.CanvasDistribution;
import jp.sourceforge.sos.cytoq.colorView.CanvasSegmentation;
import jp.sourceforge.sos.cytoq.colorView.ColoredVector;
import jp.sourceforge.sos.cytoq.message.IAnimation;
import jp.sourceforge.sos.cytoq.message.IInitSection;
import jp.sourceforge.sos.framework.model.AbstractModel;
import jp.sourceforge.sos.framework.pattern.IObserver;
import jp.sourceforge.sos.lib.image.ImagePixelMediator;
import jp.sourceforge.sos.lib.math.MathMatrix;
import jp.sourceforge.sos.lib.math.MathVector;
import jp.sourceforge.sos.lib.math.Statistics;

public class ModelColorView
extends AbstractModel<ModelColorFinal>
implements IInitSection,
IAnimation {
    private double[][] viewMx = null;
    private ColoredVector colorPoints = new ColoredVector();
    private ColoredVector unitRects = new ColoredVector();
    private Rectangle2D.Double canvasView = new Rectangle2D.Double();
    private Point2D.Double ratio = new Point2D.Double();
    private AbstractCanvas[] canvases = new AbstractCanvas[2];

    public ModelColorView() {
        this.canvases[0] = new CanvasDistribution();
        this.canvases[1] = new CanvasSegmentation();
        AbstractCanvas[] abstractCanvasArray = this.canvases;
        int n = 0;
        int n2 = abstractCanvasArray.length;
        while (n < n2) {
            AbstractCanvas c = abstractCanvasArray[n];
            c.setModel(this);
            ++n;
        }
    }

    @Override
    protected void initModel() {
        ((ModelColorFinal)this.modelParent).addObserverInitColor((IObserver)((Object)this.canvases[0]));
    }

    Image getImage(int w, int h) {
        int[] pixels = new int[w * h];
        Arrays.fill(pixels, -16777216);
        this.updatePixels(w, h, pixels);
        return ImagePixelMediator.toImage(pixels, w, h);
    }

    void updatePixels(int w, int h, int[] pixels) {
        double rw = (double)(w - 1) / this.canvasView.width;
        double rh = (double)(h - 1) / this.canvasView.height;
        this.ratio.setLocation(rw, rh);
        double[][] location = this.colorPoints.getLocation();
        int[] color = this.colorPoints.getColor();
        int in = 0;
        while (in < location.length) {
            int x = (int)(this.ratio.x * location[in][0]);
            int y = (int)(this.ratio.y * location[in][1]);
            int index = x + y * w;
            pixels[index] = -16777216 + color[in];
            ++in;
        }
    }

    int[] convertRect(int index) {
        double[] p = this.unitRects.getLocation(index);
        double x = MathVector.dot(this.viewMx[0], p) - this.canvasView.x;
        double y = MathVector.dot(this.viewMx[1], p) - this.canvasView.y;
        int[] result = new int[]{(int)(this.ratio.x * x), (int)(this.ratio.y * y)};
        return result;
    }

    int getColorNumber() {
        return ((ModelColorFinal)this.modelParent).getColorNumber();
    }

    int getHeight(int width) {
        return (int)((double)width * this.canvasView.height / this.canvasView.width);
    }

    void setPointColor(int[] color) {
        this.colorPoints.setColor(color);
    }

    public void setRectLocation(double[][] u) {
        this.unitRects.setLocation(u);
        ((ModelColorFinal)this.modelParent).setColorData(u);
    }

    int[] createColors(int[] result, int[] labels) {
        int[] colors = ((ModelColorFinal)this.modelParent).getColor();
        int i = 0;
        while (i < result.length) {
            result[i] = colors[labels[i]];
            ++i;
        }
        return result;
    }

    @Override
    public void observeInitSection(AbstractAlgorithm changed) {
        this.setPointLocation(changed.getInput());
        this.setPointColor(changed.getIntColors());
        this.setRectLocation(changed.getCopyOfUnitD());
        AbstractCanvas[] abstractCanvasArray = this.canvases;
        int n = 0;
        int n2 = abstractCanvasArray.length;
        while (n < n2) {
            AbstractCanvas view = abstractCanvasArray[n];
            view.observeInitSection(changed);
            ++n;
        }
    }

    private void setPointLocation(double[][] points) {
        Statistics stat = new Statistics(points);
        double[][] covMx = stat.getCovariance();
        this.viewMx = new double[covMx.length][covMx.length];
        MathMatrix.eigenJacobi(covMx, this.viewMx);
        this.colorPoints.createLocation(points.length);
        double[][] location = this.colorPoints.getLocation();
        int in = 0;
        while (in < points.length) {
            location[in][0] = MathVector.dot(this.viewMx[0], points[in]);
            location[in][1] = MathVector.dot(this.viewMx[1], points[in]);
            ++in;
        }
        Statistics statLoc = new Statistics(location);
        double[] minPoints = statLoc.getMin();
        this.canvasView.x = minPoints[0];
        this.canvasView.y = minPoints[1];
        int in2 = 0;
        while (in2 < points.length) {
            double[] dArray = location[in2];
            dArray[0] = dArray[0] - this.canvasView.x;
            double[] dArray2 = location[in2];
            dArray2[1] = dArray2[1] - this.canvasView.y;
            ++in2;
        }
        double[] maxPoints = statLoc.getMax();
        this.canvasView.width = maxPoints[0] - this.canvasView.x;
        this.canvasView.height = maxPoints[1] - this.canvasView.y;
    }

    @Override
    public void observeAnimation(AbstractAlgorithm changed) {
        this.setRectLocation(changed.getCopyOfUnitD());
        this.unitRects.setColor(((ModelColorFinal)this.modelParent).getColor());
        AbstractCanvas[] abstractCanvasArray = this.canvases;
        int n = 0;
        int n2 = abstractCanvasArray.length;
        while (n < n2) {
            AbstractCanvas view = abstractCanvasArray[n];
            view.observeAnimation(changed);
            ++n;
        }
    }

    public ColoredVector getUnitRects() {
        return this.unitRects;
    }

    public JComponent getCanvases(int i) {
        return this.canvases[i];
    }
}

