/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.colorView;

import jp.sourceforge.sos.cytoq.AbstractAlgorithm;
import jp.sourceforge.sos.cytoq.AnimationImage;
import jp.sourceforge.sos.cytoq.colorView.AbstractCanvas;

class CanvasSegmentation
extends AbstractCanvas {
    private AnimationImage animation = new AnimationImage();
    private int[] segmentedColors;

    CanvasSegmentation() {
    }

    @Override
    public void observeAnimation(AbstractAlgorithm changed) {
        if (!this.isVisible()) {
            return;
        }
        int[] labels = changed.getCluster();
        this.modelColorView.createColors(this.segmentedColors, labels);
        this.modelColorView.setPointColor(this.segmentedColors);
        this.modelColorView.updatePixels(this.animation.getWidth(), this.animation.getHeight(), this.animation.getPixels());
        this.animation.update();
        this.canvas.repaint();
    }

    @Override
    public void observeInitSection(AbstractAlgorithm changed) {
        this.initFrame();
        int n = changed.getIntColors().length;
        this.segmentedColors = new int[n];
        this.animation.setSize(this.canvas.getWidth(), this.canvas.getHeight());
        this.canvasBackground.setImage(this.createImage(this.animation.getImageProducer()));
        this.canvasBackground.getImageTransform().setFullSrc();
        this.canvasBackground.repaint();
    }
}

