/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.colorView;

import java.awt.Color;
import jp.sourceforge.sos.cytoq.AbstractAlgorithm;
import jp.sourceforge.sos.cytoq.colorView.AbstractCanvas;
import jp.sourceforge.sos.cytoq.colorView.ColoredVector;
import jp.sourceforge.sos.framework.pattern.IObserver;
import jp.sourceforge.sos.lib.color.ColorModel;
import jp.sourceforge.sos.lib.graphics.shape.GraphicsPointRect;

class CanvasDistribution
extends AbstractCanvas
implements IObserver<ColorModel> {
    CanvasDistribution() {
    }

    private void addRect() {
        GraphicsPointRect pr = new GraphicsPointRect(0, 0, 10);
        pr.setDrawBounds(true);
        pr.setFillRect(true);
        pr.setBoundsColor(Color.black);
        this.canvas.addGraphicObject(pr);
    }

    private void removeRect() {
        this.canvas.removeGraphicObject(this.canvas.getObjectsSize() - 1);
    }

    @Override
    public void observeAnimation(AbstractAlgorithm changed) {
        if (!this.isVisible()) {
            return;
        }
        ColoredVector v = this.modelColorView.getUnitRects();
        int[] color = v.getColor();
        int i = 0;
        while (i < color.length) {
            GraphicsPointRect pr = (GraphicsPointRect)this.canvas.getGraphicObject(i);
            int[] p = this.modelColorView.convertRect(i);
            pr.setLocation(p[0], p[1]);
            pr.setRectColor(new Color(color[i]));
            ++i;
        }
        this.canvas.repaint();
    }

    @Override
    public void observeInitSection(AbstractAlgorithm changed) {
        this.initFrame();
    }

    @Override
    public void update(ColorModel changed) {
        int n = this.modelColorView.getColorNumber() - this.canvas.getObjectsSize();
        if (n >= 0) {
            int i = 0;
            while (i < n) {
                this.addRect();
                ++i;
            }
        } else {
            int i = 0;
            while (i < -n) {
                this.removeRect();
                ++i;
            }
        }
    }
}

