/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.colorView;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import jp.sourceforge.sos.cytoq.AbstractAlgorithm;
import jp.sourceforge.sos.cytoq.colorView.ModelColorView;
import jp.sourceforge.sos.framework.ILinkModel;
import jp.sourceforge.sos.framework.model.IComponent;
import jp.sourceforge.sos.lib.canvas.JImageCanvas;
import jp.sourceforge.sos.lib.canvas.JObjectCanvas;

abstract class AbstractCanvas
extends JLayeredPane
implements ILinkModel {
    ModelColorView modelColorView;
    JObjectCanvas canvas = null;
    JImageCanvas canvasBackground = null;

    public AbstractCanvas() {
        this.initialize();
    }

    private void initialize() {
        this.add((Component)this.getCanvas(), null);
        this.add((Component)this.getCanvasBackground(), null);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName().substring(6).toUpperCase();
    }

    @Override
    public void setModel(IComponent model) {
        this.modelColorView = (ModelColorView)model;
        this.setVisible(true);
    }

    protected void initFrame() {
        int w = this.getWidth();
        int h = this.modelColorView.getHeight(w);
        this.canvasBackground.setSize(w, h);
        this.canvasBackground.setImage(this.modelColorView.getImage(w, h));
        this.canvasBackground.getImageTransform().setFullSrc();
        this.canvas.setSize(w, h);
        this.setPreferredSize(new Dimension(w, h));
        Window window = SwingUtilities.getWindowAncestor(this);
        window.pack();
    }

    private JObjectCanvas getCanvas() {
        if (this.canvas == null) {
            this.canvas = new JObjectCanvas();
            this.canvas.setOpaque(false);
        }
        return this.canvas;
    }

    private JImageCanvas getCanvasBackground() {
        if (this.canvasBackground == null) {
            this.canvasBackground = new JImageCanvas();
        }
        return this.canvasBackground;
    }

    public abstract void observeAnimation(AbstractAlgorithm var1);

    public abstract void observeInitSection(AbstractAlgorithm var1);
}

