/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.colorInit;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import jp.sourceforge.sos.cytoq.colorInit.ModelColorInit;
import jp.sourceforge.sos.framework.ILinkContainer;
import jp.sourceforge.sos.framework.ILinkModel;
import jp.sourceforge.sos.framework.model.IComponent;
import jp.sourceforge.sos.framework.pattern.IObserver;
import jp.sourceforge.sos.framework.util.SundaySingleton;
import jp.sourceforge.sos.framework.view.ContainerInAncestor;
import jp.sourceforge.sos.lib.color.ColorModel;
import jp.sourceforge.sos.lib.color.JPanelColor;

@SundaySingleton
public class ViewPanel
extends JPanel
implements ILinkModel,
ILinkContainer,
IObserver<ColorModel> {
    private ModelColorInit modelColor;
    private JLabel jLabel = null;
    private JSpinner jSpinner = null;
    @ContainerInAncestor
    private JPanel jPanelColorModels = null;
    private JPanel jPanelInit = null;
    private JPanelColor jColorPanel = null;
    private JLabel jLabel2 = null;
    private JComboBox jComboPickup = null;
    private JPanel jPanel = null;

    public ViewPanel() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridwidth = 4;
        gridBagConstraints4.gridy = 1;
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getJPanelColorModels(), gridBagConstraints4);
        this.add((Component)this.getJPanel(), new GridBagConstraints());
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setText("number:  ");
            this.jLabel.setHorizontalAlignment(4);
            this.jLabel.setForeground(Color.gray);
        }
        return this.jLabel;
    }

    private JLabel getJLabel2() {
        if (this.jLabel2 == null) {
            this.jLabel2 = new JLabel();
            this.jLabel2.setText("source:  ");
            this.jLabel2.setHorizontalAlignment(4);
            this.jLabel2.setForeground(Color.gray);
        }
        return this.jLabel2;
    }

    private JSpinner getJSpinner() {
        if (this.jSpinner == null) {
            this.jSpinner = new JSpinner();
            this.jSpinner.setPreferredSize(new Dimension(50, 20));
            this.jSpinner.setModel(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
            this.jSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int n = (Integer)ViewPanel.this.jSpinner.getValue();
                    ViewPanel.this.modelColor.updateColorNumber(n);
                }
            });
        }
        return this.jSpinner;
    }

    @Override
    public String getContainer() {
        return "jPanelColor";
    }

    @Override
    public Object getConstraints() {
        return "North";
    }

    @Override
    public void setModel(IComponent model) {
        this.modelColor = (ModelColorInit)model;
        this.jColorPanel.setModel(this.modelColor.getColorModel());
        this.jColorPanel.setLabelBase("#");
        this.jColorPanel.setChoosable(true);
        this.jComboPickup.setModel(this.modelColor.getPickups());
        this.modelColor.addObserverInitColor(this);
    }

    private JPanel getJPanelColorModels() {
        if (this.jPanelColorModels == null) {
            this.jPanelColorModels = new JPanel();
            this.jPanelColorModels.setLayout(new BorderLayout());
            this.jPanelColorModels.add((Component)this.getJPanelInit(), "West");
        }
        return this.jPanelColorModels;
    }

    private JPanel getJPanelInit() {
        if (this.jPanelInit == null) {
            this.jPanelInit = new JPanel();
            this.jPanelInit.setLayout(new BorderLayout());
            this.jPanelInit.setBorder(BorderFactory.createTitledBorder(null, "Initial", 0, 0, new Font("Dialog", 1, 12), Color.blue));
            this.jPanelInit.add((Component)this.getJColorPanel(), "Center");
        }
        return this.jPanelInit;
    }

    private JPanelColor getJColorPanel() {
        if (this.jColorPanel == null) {
            this.jColorPanel = new JPanelColor();
        }
        return this.jColorPanel;
    }

    private JComboBox getJComboPickup() {
        if (this.jComboPickup == null) {
            this.jComboPickup = new JComboBox();
        }
        return this.jComboPickup;
    }

    @Override
    public void update(ColorModel changed) {
        int n = this.modelColor.getColorNumber();
        this.jSpinner.setValue(n);
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(1);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = -1;
            gridBagConstraints2.gridy = -1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints3.gridy = -1;
            gridBagConstraints3.gridx = -1;
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridx = -1;
            gridBagConstraints1.gridy = -1;
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 10, 0, 0);
            gridBagConstraints.gridy = -1;
            gridBagConstraints.gridx = -1;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(gridLayout);
            this.jPanel.add((Component)this.getJLabel(), null);
            this.jPanel.add((Component)this.getJSpinner(), null);
            this.jPanel.add((Component)this.getJLabel2(), null);
            this.jPanel.add((Component)this.getJComboPickup(), null);
        }
        return this.jPanel;
    }
}

