/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.colorInit;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jp.sourceforge.sos.cytoq.AbstractAlgorithm;
import jp.sourceforge.sos.cytoq.IPickup;
import jp.sourceforge.sos.cytoq.colorInit.ModelColorInit;
import jp.sourceforge.sos.cytoq.colorInit.PresetData;
import jp.sourceforge.sos.framework.ILinkModel;
import jp.sourceforge.sos.framework.ILinkViewWrapper;
import jp.sourceforge.sos.framework.model.IComponent;
import jp.sourceforge.sos.lib.color.ColorPanelModel;
import jp.sourceforge.sos.lib.color.JPanelColor;
import jp.sourceforge.sos.lib.io.SOSFileIO;
import jp.sourceforge.sos.lib.variablePanel.JVariablePanel;
import jp.sourceforge.sos.lib.view.ViewMenuItem;

class PickupPreset
extends JDialog
implements IPickup,
ILinkModel,
ILinkViewWrapper {
    private static final File file;
    private static final PresetData DEFAULT_DATA;
    private PresetData currentData;
    private boolean modified;
    private ModelColorInit modelColor;
    private JPanel jContentPane = null;
    private JVariablePanel jColorPanel = null;
    private JPanel jPanel = null;
    private JButton jButtonAdd = null;
    private JButton jButtonRename = null;
    private JButton jButtonRemove = null;
    private JButton jButtonUpdate = null;
    private JPanel jPanel1 = null;
    private JTextField jTextName = null;
    private JComboBox jComboPresets = null;
    private CardLayout cardLayout = new CardLayout();

    static {
        DEFAULT_DATA = new PresetData();
        file = new File(String.valueOf(System.getProperty("user.dir")) + File.separator + "ColorPresets.dat");
        DEFAULT_DATA.setName("IHC3");
        DEFAULT_DATA.setData(new int[]{-1, -6710785, -4939616});
    }

    PickupPreset() {
        super((Frame)new JFrame(), false);
        this.initComponents();
        this.cardLayout.show(this.jPanel1, this.jComboPresets.getName());
        this.loadItem();
    }

    private void loadItem() {
        ArrayList<String> args = SOSFileIO.readStrings(file);
        if (args.size() == 0) {
            this.jComboPresets.addItem(DEFAULT_DATA);
            return;
        }
        int i = 0;
        while (i < args.size()) {
            PresetData data = new PresetData();
            data.set(args.get(i));
            this.jComboPresets.addItem(data);
            ++i;
        }
    }

    @Override
    public String toString() {
        return "Preset";
    }

    private void saveItems() {
        String[] result = new String[this.jComboPresets.getItemCount()];
        int i = 0;
        while (i < result.length) {
            PresetData data = (PresetData)this.jComboPresets.getItemAt(i);
            result[i] = data.getSaveString();
            ++i;
        }
        SOSFileIO.writeStrings(file, result);
    }

    private void rename() {
        this.jTextName.setText(this.currentData.toString());
        this.cardLayout.show(this.jPanel1, this.jTextName.getName());
        this.jTextName.requestFocus();
    }

    private void setPresetName() {
        this.cardLayout.show(this.jPanel1, this.jComboPresets.getName());
        this.currentData.setName(this.jTextName.getText());
        this.pack();
        this.modified = true;
    }

    private void init() {
        this.modelColor.setSelected(this);
        this.modified = false;
    }

    private void initComponents() {
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Preset Manager");
        this.setSize(new Dimension(226, 164));
        this.setContentPane(this.getJContentPane());
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentHidden(ComponentEvent e) {
                if (PickupPreset.this.modified) {
                    PickupPreset.this.saveItems();
                }
            }

            @Override
            public void componentShown(ComponentEvent e) {
                PickupPreset.this.init();
            }
        });
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getPanelInit(), "Center");
            this.jContentPane.add((Component)this.getJPanel(), "East");
            this.jContentPane.add((Component)this.getJPanel1(), "North");
        }
        return this.jContentPane;
    }

    private JVariablePanel getPanelInit() {
        if (this.jColorPanel == null) {
            this.jColorPanel = new JPanelColor();
        }
        return this.jColorPanel;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridLayout gridLayout = new GridLayout();
            gridLayout.setRows(4);
            gridLayout.setColumns(1);
            this.jPanel = new JPanel();
            this.jPanel.setLayout(gridLayout);
            this.jPanel.add((Component)this.getJButtonUpdate(), null);
            this.jPanel.add((Component)this.getJButtonRename(), null);
            this.jPanel.add((Component)this.getJButtonRemove(), null);
            this.jPanel.add((Component)this.getJButtonAdd(), null);
        }
        return this.jPanel;
    }

    private JButton getJButtonAdd() {
        if (this.jButtonAdd == null) {
            this.jButtonAdd = new JButton();
            this.jButtonAdd.setText("ADD");
            this.jButtonAdd.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PickupPreset.this.jComboPresets.addItem(new PresetData("New Preset", PickupPreset.this.getColorInt(PickupPreset.this.jColorPanel)));
                    PickupPreset.this.jComboPresets.setSelectedIndex(PickupPreset.this.jComboPresets.getItemCount() - 1);
                    PickupPreset.this.rename();
                    PickupPreset.this.pack();
                    PickupPreset.this.modified = true;
                }
            });
        }
        return this.jButtonAdd;
    }

    private JButton getJButtonRename() {
        if (this.jButtonRename == null) {
            this.jButtonRename = new JButton();
            this.jButtonRename.setText("RENAME");
            this.jButtonRename.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PickupPreset.this.rename();
                }
            });
        }
        return this.jButtonRename;
    }

    private JButton getJButtonRemove() {
        if (this.jButtonRemove == null) {
            this.jButtonRemove = new JButton();
            this.jButtonRemove.setText("REMOVE");
            this.jButtonRemove.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int index = PickupPreset.this.jComboPresets.getSelectedIndex();
                    PickupPreset.this.jComboPresets.removeItemAt(index);
                    PickupPreset.this.modified = true;
                }
            });
        }
        return this.jButtonRemove;
    }

    private JButton getJButtonUpdate() {
        if (this.jButtonUpdate == null) {
            this.jButtonUpdate = new JButton();
            this.jButtonUpdate.setText("UPDATE");
            this.jButtonUpdate.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PresetData data = (PresetData)PickupPreset.this.jComboPresets.getSelectedItem();
                    data.setData(PickupPreset.this.getColorInt(PickupPreset.this.jColorPanel));
                    PickupPreset.this.modified = true;
                }
            });
        }
        return this.jButtonUpdate;
    }

    protected int[] getColorInt(JVariablePanel colorPanel) {
        ColorPanelModel model = (ColorPanelModel)colorPanel.getModel();
        int[] result = new int[model.getNumber()];
        int i = 0;
        while (i < result.length) {
            result[i] = model.getColorInt(i);
            ++i;
        }
        return result;
    }

    private JPanel getJPanel1() {
        if (this.jPanel1 == null) {
            this.jPanel1 = new JPanel();
            this.jPanel1.setLayout(this.cardLayout);
            this.jPanel1.add((Component)this.getJTextName(), this.getJTextName().getName());
            this.jPanel1.add((Component)this.getJComboPresets(), this.getJComboPresets().getName());
        }
        return this.jPanel1;
    }

    private JTextField getJTextName() {
        if (this.jTextName == null) {
            this.jTextName = new JTextField();
            this.jTextName.setName("jTextName");
            this.jTextName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PickupPreset.this.setPresetName();
                }
            });
            this.jTextName.addFocusListener(new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent e) {
                    PickupPreset.this.setPresetName();
                }
            });
        }
        return this.jTextName;
    }

    private JComboBox getJComboPresets() {
        if (this.jComboPresets == null) {
            this.jComboPresets = new JComboBox();
            this.jComboPresets.setName("jComboPresets");
            this.jComboPresets.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    PickupPreset.this.currentData = (PresetData)PickupPreset.this.jComboPresets.getSelectedItem();
                    if (PickupPreset.this.modelColor != null) {
                        PickupPreset.this.modelColor.init();
                    }
                }
            });
        }
        return this.jComboPresets;
    }

    @Override
    public void setModel(IComponent model) {
        this.modelColor = (ModelColorInit)model;
        this.jColorPanel.setLabelName("Initial");
        this.jColorPanel.setModel(this.modelColor.getColorModel());
        this.jColorPanel.setLabelBase("#");
        ((JPanelColor)this.jColorPanel).setChoosable(true);
        this.modelColor.insertPickup(this, 0);
    }

    @Override
    public JComponent getWrapper() {
        return new ViewMenuItem(this);
    }

    @Override
    public String getContainer() {
        return "jMenuTools";
    }

    @Override
    public Object getConstraints() {
        return NO_CONSTRAINT;
    }

    @Override
    public int[] getColor(AbstractAlgorithm algorithm) {
        PresetData data = (PresetData)this.jComboPresets.getSelectedItem();
        return data.getData();
    }
}

