/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.colorInit;

import javax.swing.ComboBoxModel;
import jp.sourceforge.sos.cytoq.AbstractAlgorithm;
import jp.sourceforge.sos.cytoq.IPickup;
import jp.sourceforge.sos.cytoq.colorInit.PickupNull;
import jp.sourceforge.sos.cytoq.main.ModelMain;
import jp.sourceforge.sos.cytoq.message.IInitSection;
import jp.sourceforge.sos.framework.IInitializeLast;
import jp.sourceforge.sos.framework.model.AbstractModel;
import jp.sourceforge.sos.framework.pattern.ComboModelStrategy;
import jp.sourceforge.sos.framework.pattern.IObserver;
import jp.sourceforge.sos.lib.color.ColorModel;
import jp.sourceforge.sos.lib.color.ColorPanelModel;
import jp.sourceforge.sos.lib.colorspace.SOSColorSpace;

public class ModelColorInit
extends AbstractModel<ModelMain>
implements IInitializeLast,
IInitSection {
    public ColorPanelModel colorModel;
    private ComboModelStrategy<IPickup> pickups = new ComboModelStrategy();

    public ModelColorInit() {
        this.pickups.add(new PickupNull());
        this.colorModel = new ColorPanelModel();
        this.colorModel.setName("Initial");
    }

    @Override
    protected void initModel() {
    }

    public ColorPanelModel getColorModel() {
        return this.colorModel;
    }

    void insertPickup(IPickup pickup, int index) {
        this.pickups.insertElementAt(pickup, index);
    }

    public int getColorNumber() {
        return this.colorModel.getNumber();
    }

    ComboBoxModel getPickups() {
        return this.pickups;
    }

    IPickup getPickup() {
        return this.pickups.getSelected();
    }

    void setSelected(IPickup pickup) {
        this.pickups.setSelectedItem(pickup);
    }

    @Override
    public void observeInitSection(AbstractAlgorithm changed) {
        int[] color = changed.getUnitColor();
        if (color != null) {
            this.setCurrentPickup(1);
            this.updateColor(color);
        } else {
            this.setColors();
        }
        double[][] u = ((ModelMain)this.modelParent).getColorSpace().fromRGB(this.colorModel.getColorArray());
        changed.setUnit(u);
    }

    @Override
    public void init() {
        this.setCurrentPickup(0);
        this.setColors();
    }

    private void setCurrentPickup(int index) {
        IPickup current = (IPickup)this.pickups.getElementAt(index);
        this.pickups.setSelectedItem(current);
    }

    private void setColors() {
        IPickup current = this.pickups.getSelected();
        int[] color = current.getColor(((ModelMain)this.modelParent).getAlgorithm());
        if (color.length > 0) {
            this.updateColor(color);
        }
    }

    public void updateColor(int[] color) {
        this.updateColorNumber(color.length);
        this.colorModel.updateColor(color);
    }

    void updateColorNumber(int n) {
        this.colorModel.setNumber(n);
    }

    public void addObserverInitColor(IObserver<ColorModel> obj) {
        this.colorModel.addObserver(obj);
    }

    public SOSColorSpace getColorSpace() {
        return ((ModelMain)this.modelParent).getColorSpace();
    }
}

