/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq.colorFinal;

import jp.sourceforge.sos.cytoq.colorInit.ModelColorInit;
import jp.sourceforge.sos.framework.model.AbstractModel;
import jp.sourceforge.sos.framework.pattern.IObserver;
import jp.sourceforge.sos.lib.color.ColorModel;
import jp.sourceforge.sos.lib.color.ColorPanelModel;
import jp.sourceforge.sos.lib.colorspace.SOSColorSpace;

public class ModelColorFinal
extends AbstractModel<ModelColorInit>
implements IObserver<ColorModel> {
    private ColorPanelModel colorModel = new ColorPanelModel();

    public ModelColorFinal() {
        this.colorModel.setName("Final");
    }

    void transferToInit() {
        int[] colors = this.colorModel.getColorInt();
        ((ModelColorInit)this.modelParent).updateColor(colors);
    }

    @Override
    protected void initModel() {
        ((ModelColorInit)this.modelParent).addObserverInitColor(this);
    }

    public void setColorData(double[][] units) {
        if (units != null) {
            SOSColorSpace colorSpace = ((ModelColorInit)this.modelParent).getColorSpace();
            this.colorModel.updateColor(colorSpace.toRGB(units));
        }
    }

    public ColorPanelModel getInitColors() {
        return ((ModelColorInit)this.modelParent).getColorModel();
    }

    public ColorPanelModel getColorModel() {
        return this.colorModel;
    }

    @Override
    public void update(ColorModel changed) {
        int n = ((ModelColorInit)this.modelParent).getColorNumber();
        this.colorModel.setNumber(n);
    }

    public int getColorNumber() {
        return ((ModelColorInit)this.modelParent).getColorNumber();
    }

    public int[] getColor() {
        return this.colorModel.getColorInt();
    }

    public void addObserverInitColor(IObserver<ColorModel> obj) {
        ((ModelColorInit)this.modelParent).addObserverInitColor(obj);
    }
}

