/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.sos.cytoq;

import java.awt.image.BufferedImage;
import java.io.File;
import java.util.TreeMap;
import javax.swing.JComboBox;
import jp.sourceforge.sos.cytoq.main.AbstractFileHandler;
import jp.sourceforge.sos.lib.image.ImageColors;
import jp.sourceforge.sos.lib.image.ImagePixelMediator;
import jp.sourceforge.sos.lib.image.LabeledImage;
import jp.sourceforge.sos.lib.math.Clustering;
import jp.sourceforge.sos.lib.math.IOptionComponent;

public abstract class AbstractAlgorithm<T>
extends Clustering
implements IOptionComponent<T> {
    protected static ImageColors imageColor = new ImageColors();
    private static LabeledImage labeledImage = new LabeledImage();
    protected AbstractFileHandler fileHandler;
    protected int[] histogram;

    @Override
    public abstract boolean isConvoluted();

    @Override
    public abstract void calculate();

    public abstract boolean initProcess();

    @Override
    public String toString() {
        return this.getClass().getName();
    }

    public void setFileHandler(AbstractFileHandler fileHandler) {
        this.fileHandler = fileHandler;
    }

    public String getName() {
        return this.getLabeledImage().getName();
    }

    public int[] getIntColors() {
        return imageColor.getIntColors();
    }

    public LabeledImage getLabeledImage() {
        return labeledImage;
    }

    public final void initSection() {
        this.fileHandler.next();
        File file = this.fileHandler.getCurrentFile();
        if (file != null) {
            this.initSection(file);
        }
    }

    public abstract void initSection(File var1);

    protected void makeImageColors(File file) {
        TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
        imageColor.makeMap(file, map);
        imageColor.setupFromMap(map);
    }

    protected void makeLabeledImage(File file) {
        labeledImage.setFile(file);
        labeledImage.makePixelsColorsTable(imageColor);
    }

    public ImageColors getImageColor() {
        return imageColor;
    }

    public int[] getUnitColor() {
        return null;
    }

    public void confineFile(JComboBox obj) {
        obj.setEnabled(true);
    }

    public void endProcess() {
    }

    protected int[] getIntArray(BufferedImage img) {
        if (img == null) {
            return null;
        }
        int[] a = ImagePixelMediator.toPixels(img);
        int[] result = new int[a.length];
        int i = 0;
        while (i < a.length) {
            result[i] = a[i] & 0xFFFFFF;
            ++i;
        }
        return result;
    }
}

