/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import jp.sourceforge.sos.cytoq.AbstractAlgorithm;
import jp.sourceforge.sos.lib.image.ImageColors;
import jp.sourceforge.sos.lib.image.ImagePixelMediator;
import jp.sourceforge.sos.lib.io.SOSImageIO;
import jp.sourceforge.sos.lib.util.MinMaxInteger;

public class Matching
extends AbstractAlgorithm<ImageColors> {
    private SOSImageIO imageIO = SOSImageIO.getInstance();
    private int[] colors;
    private int[] labels;
    private int[] unitColor;

    @Override
    public void calculate() {
        int[] c = imageColor.getIntColors();
        int i = 0;
        while (i < c.length) {
            int index = Arrays.binarySearch(this.colors, c[i]);
            this.cluster[i] = this.labels[index];
            ++i;
        }
        this.cumulate();
        this.calcMean(true);
    }

    @Override
    public void setParameter(ImageColors obj) {
    }

    @Override
    public boolean isConvoluted() {
        return true;
    }

    @Override
    public boolean initProcess() {
        this.colors = this.getIntArray(this.getImage("COLORS"));
        this.labels = this.getLabel(this.getImage("LABELS"));
        if (this.colors == null || this.labels == null) {
            return false;
        }
        int n = this.findMaxLabel() + 1;
        this.unitColor = new int[n];
        this.createUnitColor();
        return true;
    }

    private int[] getLabel(BufferedImage image) {
        int[] pixels = ImagePixelMediator.toPixels(image);
        int[] result = new int[pixels.length];
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < result.length) {
            result[i] = list.indexOf(pixels[i]);
            if (result[i] == -1) {
                result[i] = list.size();
                list.add(pixels[i]);
            }
            ++i;
        }
        return result;
    }

    private BufferedImage getImage(String arg) {
        String s = "Select the image of " + arg + ".";
        return this.imageIO.readImage(s);
    }

    private int findMaxLabel() {
        MinMaxInteger mmi = new MinMaxInteger();
        mmi.compareMax(this.labels);
        return mmi.getValue();
    }

    private void createUnitColor() {
        long[][] vectors = new long[this.unitColor.length][3];
        int[] counts = new int[this.unitColor.length];
        int i = 0;
        while (i < this.colors.length) {
            int index;
            int n = index = this.labels[i];
            counts[n] = counts[n] + 1;
            long[] lArray = vectors[index];
            lArray[0] = lArray[0] + (long)(this.colors[i] >> 16 & 0xFF);
            long[] lArray2 = vectors[index];
            lArray2[1] = lArray2[1] + (long)(this.colors[i] >> 8 & 0xFF);
            long[] lArray3 = vectors[index];
            lArray3[2] = lArray3[2] + (long)(this.colors[i] >> 0 & 0xFF);
            ++i;
        }
        i = 0;
        while (i < this.unitColor.length) {
            int r = (int)(vectors[i][0] / (long)counts[i]);
            int g = (int)(vectors[i][1] / (long)counts[i]);
            int b = (int)(vectors[i][2] / (long)counts[i]);
            this.unitColor[i] = (r << 16) + (g << 8) + b;
            ++i;
        }
    }

    @Override
    public int[] getUnitColor() {
        return this.unitColor;
    }

    @Override
    public void initSection(File file) {
        this.makeImageColors(file);
        this.makeLabeledImage(file);
    }
}

