/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.util.Arrays;
import jp.sourceforge.sos.cytoq.AbstractAlgorithm;
import jp.sourceforge.sos.lib.image.LabeledImage;
import jp.sourceforge.sos.lib.math.MathVector;
import jp.sourceforge.sos.lib.morphology.connection.AbstractNeighbor;
import jp.sourceforge.sos.lib.panel.JGenericPanel;
import jp.sourceforge.sos.lib.util.MinMaxDouble;
import jp.sourceforge.sos.lib.util.MinMaxInteger;
import jp.sourceforge.sos.lib.util.Sets;

public class MarkovMeans
extends AbstractAlgorithm<LabeledImage> {
    private LabeledImage imi;
    double beta = 0.0;
    double betaDelta;
    double[] neighborBeta;
    double sentinel;
    double[][] preConvolutedUnit;
    int[] oldLabel;
    double[][] oldUnitMean;

    public MarkovMeans() {
        JGenericPanel panel = new JGenericPanel();
        panel.addNumericField("beta ", 1.0, 1);
        this.optionPanel = panel;
    }

    @Override
    public void calculate() {
        int[] table = this.imi.getPixelColorTable();
        int[] nSameLabeledNeighbor = new int[this.nUnit];
        double[] preP = new double[this.nUnit];
        AbstractNeighbor nf = this.imi.getNeighbor();
        nf.set8();
        MinMaxDouble mmd = new MinMaxDouble();
        int[] labels = this.imi.getLabels();
        this.initCalculation();
        int pn = 0;
        while (pn < this.imi.getImageSize()) {
            int[] neighbors = nf.getExist(pn);
            Arrays.fill(nSameLabeledNeighbor, 0);
            int n = 0;
            while (n < neighbors.length) {
                int n2 = labels[pn + neighbors[n]];
                nSameLabeledNeighbor[n2] = nSameLabeledNeighbor[n2] + 1;
                ++n;
            }
            double sumP = 0.0;
            int un = 0;
            while (un < this.nUnit) {
                preP[un] = this.neighborBeta[nSameLabeledNeighbor[un]];
                sumP += preP[un];
                ++un;
            }
            un = 0;
            while (un < this.nUnit) {
                int n3 = un++;
                preP[n3] = preP[n3] / sumP;
            }
            double[] inp = this.input[table[pn]];
            mmd.initialize();
            un = 0;
            while (un < this.nUnit) {
                mmd.compareMin(Math.sqrt(MathVector.norm(inp, this.units[un].mean)) / preP[un]);
                ++un;
            }
            this.imi.setPixelsLabel(pn, mmd.getIndex());
            int d = 0;
            while (d < this.dim) {
                int n4 = d;
                this.units[mmd.getIndex()].cumInput[n4] = this.units[mmd.getIndex()].cumInput[n4] + inp[d];
                ++d;
            }
            this.units[mmd.getIndex()].nBelong += 1.0;
            ++pn;
        }
        this.calcMean(true);
        this.setClusterFromLabel(this.nUnit, this.cluster);
    }

    private void setClusterFromLabel(int nUnit, int[] cluster) {
        int[] labels = this.imi.getLabels();
        int[] table = this.imi.getPixelColorTable();
        int[][] nLabel = new int[this.imi.getColorNumber()][nUnit];
        int pn = 0;
        while (pn < labels.length) {
            int[] nArray = nLabel[table[pn]];
            int n = labels[pn];
            nArray[n] = nArray[n] + 1;
            ++pn;
        }
        MinMaxInteger mmi = new MinMaxInteger();
        int in = 0;
        while (in < nLabel.length) {
            mmi.compareMax(nLabel[in]);
            cluster[in] = mmi.getIndex();
            ++in;
        }
    }

    @Override
    public boolean isConvoluted() {
        return this.evaluatedValue < this.desiredValue;
    }

    private void setClusterAndLabel() {
        int in = 0;
        while (in < this.nInput) {
            this.cluster[in] = Sets.findNearest(this.getMeanD(), this.input[in]);
            ++in;
        }
        int[] table = this.imi.getPixelColorTable();
        int pn = 0;
        while (pn < this.imi.getImageSize()) {
            this.imi.setPixelsLabel(pn, this.cluster[table[pn]]);
            ++pn;
        }
    }

    @Override
    public void setParameter(LabeledImage imi) {
        this.imi = imi;
        this.moveUnitsToNearestInputs();
        this.setClusterAndLabel();
        if (this.optionPanel != null) {
            this.beta = ((JGenericPanel)this.optionPanel).getFieldNumber(0);
            this.betaDelta = this.beta / 10.0;
            AbstractNeighbor nf = imi.getNeighbor();
            nf.set8();
            this.neighborBeta = new double[nf.getNumber() + 1];
            this.setBetaArray();
            this.oldLabel = new int[imi.getImageSize()];
            this.oldUnitMean = new double[this.nUnit][this.dim];
            this.backup();
            this.sentinel = Double.NEGATIVE_INFINITY;
        }
    }

    private void setBetaArray() {
        int i = 0;
        while (i < this.neighborBeta.length) {
            this.neighborBeta[i] = Math.exp((double)i * this.beta);
            ++i;
        }
    }

    private void backup() {
        int[] pixelsLabel = this.imi.getLabels();
        int pn = 0;
        while (pn < this.imi.getImageSize()) {
            this.oldLabel[pn] = pixelsLabel[pn];
            ++pn;
        }
        int i = 0;
        while (i < this.oldUnitMean.length) {
            double[] current = this.getMeanD(i);
            System.arraycopy(current, 0, this.oldUnitMean[i], 0, this.dim);
            ++i;
        }
    }

    public void setPixelsLabel(LabeledImage imi) {
    }

    @Override
    public boolean initProcess() {
        return true;
    }

    @Override
    public void initSection(File file) {
    }
}

