/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.StreamCorruptedException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import jp.sourceforge.sos.cytoq.AbstractAlgorithm;
import jp.sourceforge.sos.lib.image.ImageColors;
import jp.sourceforge.sos.lib.io.SOSImageIO;
import jp.sourceforge.sos.lib.panel.JGenericPanel;

public class KMeans
extends AbstractAlgorithm<ImageColors> {
    protected static final String pathChunk = "UnknownChunks/UnknownChunk";
    protected static final String[] attr = new String[]{"type/tkFl"};
    protected int indexParameter;

    public KMeans() {
        String[] colorType = new String[]{"full color", "all pixels"};
        JGenericPanel panel = new JGenericPanel();
        panel.addChoice("sampling", colorType, 0);
        this.optionPanel = panel;
    }

    @Override
    public void calculate() {
        this.initCalculation();
        this.findNearestMean(this.input);
        if (this.histogram == null) {
            this.cumulate();
        } else {
            this.cumulate(this.histogram);
        }
        this.calcMean(true);
    }

    @Override
    public boolean isConvoluted() {
        return this.evaluatedValue < this.desiredValue;
    }

    @Override
    public boolean initProcess() {
        this.setParameter(null);
        return true;
    }

    @Override
    public void setParameter(ImageColors obj) {
        this.indexParameter = ((JGenericPanel)this.optionPanel).getChoiceIndex(0);
    }

    @Override
    public void initSection(File file) {
        int[] h = this.getMetadataObject(file);
        if (h != null) {
            int[] colors = this.getIntArray(SOSImageIO.readImage(file));
            imageColor.setIntColors(colors);
            imageColor.setHistogram(h);
        } else {
            this.makeImageColors(file);
        }
        this.makeLabeledImage(file);
        this.histogram = this.indexParameter == 0 ? null : imageColor.getHistogram();
    }

    private int[] getMetadataObject(File file) {
        IIOMetadata metadata = SOSImageIO.getMetadata(file);
        if (metadata == null) {
            return null;
        }
        byte[] data = null;
        try {
            IIOMetadataNode root = (IIOMetadataNode)metadata.getAsTree(metadata.getNativeMetadataFormatName());
            IIOMetadataNode node = SOSImageIO.getNode(root, pathChunk, attr);
            if (node != null) {
                data = (byte[])node.getUserObject();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.getObject(data);
    }

    private int[] getObject(byte[] data) {
        int[] result = null;
        if (data != null) {
            try {
                ByteArrayInputStream byteIn = new ByteArrayInputStream(data);
                ObjectInputStream objectIn = new ObjectInputStream(byteIn);
                result = (int[])objectIn.readObject();
                objectIn.close();
                byteIn.close();
            }
            catch (StreamCorruptedException e) {
                System.out.println("Error but OK");
            }
            catch (ClassCastException e) {
                System.out.println("Error but OK");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

